/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.nio.ByteBuffer;
import org.eclipse.jetty.toolchain.test.ByteBufferUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;

public class ByteBufferAssert {
    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        MatcherAssert.assertThat(message + " byte[].length", actual.length, CoreMatchers.is(expected.length));
        int len = expected.length;
        for (int i2 = 0; i2 < len; ++i2) {
            MatcherAssert.assertThat(message + " byte[" + i2 + "]", actual[i2], CoreMatchers.is(expected[i2]));
        }
    }

    public static void assertEquals(String message, ByteBuffer expectedBuffer, ByteBuffer actualBuffer) {
        if (expectedBuffer == null) {
            MatcherAssert.assertThat(message, actualBuffer, CoreMatchers.nullValue());
        } else {
            byte[] expectedBytes = ByteBufferUtils.toArray(expectedBuffer);
            byte[] actualBytes = ByteBufferUtils.toArray(actualBuffer);
            ByteBufferAssert.assertEquals(message, expectedBytes, actualBytes);
        }
    }

    public static void assertEquals(String message, String expectedString, ByteBuffer actualBuffer) {
        String actualString = ByteBufferUtils.toString(actualBuffer);
        MatcherAssert.assertThat(message, actualString, CoreMatchers.is(expectedString));
    }

    public static void assertSize(String message, int expectedSize, ByteBuffer buffer) {
        if (expectedSize == 0 && buffer == null) {
            return;
        }
        MatcherAssert.assertThat(message + " buffer.remaining", buffer.remaining(), CoreMatchers.is(expectedSize));
    }
}

