/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ClassLoaderDump;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.ClasspathPattern;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppClassLoader;

@ManagedObject(value="Web Application ContextHandler")
public class WebAppContext
extends ServletContextHandler
implements WebAppClassLoader.Context {
    static final Logger LOG = Log.getLogger(WebAppContext.class);
    public static final String TEMPDIR = "javax.servlet.context.tempdir";
    public static final String BASETEMPDIR = "org.eclipse.jetty.webapp.basetempdir";
    public static final String WEB_DEFAULTS_XML = "org/eclipse/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    public static final String SERVER_SYS_CLASSES = "org.eclipse.jetty.webapp.systemClasses";
    public static final String SERVER_SRV_CLASSES = "org.eclipse.jetty.webapp.serverClasses";
    private static final String[] DEFAULT_PROTECTED_TARGETS = new String[]{"/web-inf", "/meta-inf"};
    public static final String[] DEFAULT_CONFIGURATION_CLASSES = new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"};
    public static final String[] __dftSystemClasses = new String[]{"java.", "javax.", "org.xml.", "org.w3c.", "org.eclipse.jetty.jmx.", "org.eclipse.jetty.util.annotation.", "org.eclipse.jetty.continuation.", "org.eclipse.jetty.jndi.", "org.eclipse.jetty.jaas.", "org.eclipse.jetty.websocket.", "org.eclipse.jetty.util.log.", "org.eclipse.jetty.servlet.DefaultServlet", "org.eclipse.jetty.jsp.JettyJspServlet", "org.eclipse.jetty.servlets.PushCacheFilter", "org.eclipse.jetty.servlets.PushSessionCacheFilter"};
    public static final String[] __dftServerClasses = new String[]{"-org.eclipse.jetty.server.session.SessionData", "-org.eclipse.jetty.jmx.", "-org.eclipse.jetty.util.annotation.", "-org.eclipse.jetty.continuation.", "-org.eclipse.jetty.jndi.", "-org.eclipse.jetty.jaas.", "-org.eclipse.jetty.servlets.", "-org.eclipse.jetty.servlet.DefaultServlet", "-org.eclipse.jetty.servlet.NoJspServlet", "-org.eclipse.jetty.jsp.", "-org.eclipse.jetty.servlet.listener.", "-org.eclipse.jetty.websocket.", "-org.eclipse.jetty.apache.", "-org.eclipse.jetty.util.log.", "-org.eclipse.jetty.alpn.", "org.objectweb.asm.", "org.eclipse.jdt.", "org.eclipse.jetty."};
    private final List<String> _configurationClasses = new ArrayList<String>();
    private ClasspathPattern _systemClasses = null;
    private ClasspathPattern _serverClasses = null;
    private final List<Configuration> _configurations = new ArrayList<Configuration>();
    private String _defaultsDescriptor = "org/eclipse/jetty/webapp/webdefault.xml";
    private String _descriptor = null;
    private final List<String> _overrideDescriptors = new ArrayList<String>();
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _copyWebInf = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.eclipse.jetty.server.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _contextWhiteList = null;
    private File _tmpDir;
    private boolean _persistTmpDir = false;
    private String _war;
    private String _extraClasspath;
    private Throwable _unavailableException;
    private Map<String, String> _resourceAliases;
    private boolean _ownClassLoader = false;
    private boolean _configurationDiscovered = false;
    private boolean _allowDuplicateFragmentNames = false;
    private boolean _throwUnavailableOnStartupException = false;
    private MetaData _metadata = new MetaData();

    public static WebAppContext getCurrentWebAppContext() {
        ContextHandler handler;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null && (handler = context.getContextHandler()) instanceof WebAppContext) {
            return (WebAppContext)handler;
        }
        return null;
    }

    public WebAppContext() {
        this(null, null, null, null, null, new ErrorPageErrorHandler(), 3);
    }

    public WebAppContext(String webApp, String contextPath) {
        this(null, contextPath, null, null, null, new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(Resource webApp, String contextPath) {
        this(null, contextPath, null, null, null, new ErrorPageErrorHandler(), 3);
        this.setWarResource(webApp);
    }

    public WebAppContext(HandlerContainer parent, String webApp, String contextPath) {
        this(parent, contextPath, null, null, null, new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(HandlerContainer parent, Resource webApp, String contextPath) {
        this(parent, contextPath, null, null, null, new ErrorPageErrorHandler(), 3);
        this.setWarResource(webApp);
    }

    public WebAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(null, null, sessionHandler, securityHandler, servletHandler, errorHandler, 0);
    }

    public WebAppContext(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler, int options) {
        super(parent, contextPath, sessionHandler, securityHandler, servletHandler, errorHandler, options);
        this._scontext = new Context();
        this.setErrorHandler(errorHandler != null ? errorHandler : new ErrorPageErrorHandler());
        this.setProtectedTargets(DEFAULT_PROTECTED_TARGETS);
    }

    @Override
    public void setDisplayName(String servletContextName) {
        super.setDisplayName(servletContextName);
        ClassLoader cl = this.getClassLoader();
        if (cl instanceof WebAppClassLoader && servletContextName != null) {
            ((WebAppClassLoader)cl).setName(servletContextName);
        }
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap<String, String>(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map<String, String> getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map<String, String> map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String path) {
        if (this._resourceAliases == null) {
            return null;
        }
        String alias = this._resourceAliases.get(path);
        int slash = path.length();
        while (alias == null && (slash = path.lastIndexOf("/", slash - 1)) >= 0) {
            String match = this._resourceAliases.get(path.substring(0, slash + 1));
            if (match == null) continue;
            alias = match + path.substring(slash + 1);
        }
        return alias;
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases.remove(alias);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        String name = this.getDisplayName();
        if (name == null) {
            name = this.getContextPath();
        }
        if (classLoader instanceof WebAppClassLoader && this.getDisplayName() != null) {
            ((WebAppClassLoader)classLoader).setName(name);
        }
    }

    @Override
    public Resource getResource(String uriInContext) throws MalformedURLException {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            throw new MalformedURLException(uriInContext);
        }
        IOException ioe = null;
        Resource resource = null;
        int loop = 0;
        while (uriInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(uriInContext);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                uriInContext = this.getResourceAlias(uriInContext);
            }
            catch (IOException e) {
                LOG.ignore(e);
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe instanceof MalformedURLException) {
            throw (MalformedURLException)ioe;
        }
        return resource;
    }

    public boolean isConfigurationDiscovered() {
        return this._configurationDiscovered;
    }

    public void setConfigurationDiscovered(boolean discovered) {
        this._configurationDiscovered = discovered;
    }

    public void preConfigure() throws Exception {
        this.loadConfigurations();
        this.loadSystemClasses();
        this.loadServerClasses();
        this._ownClassLoader = false;
        if (this.getClassLoader() == null) {
            WebAppClassLoader classLoader = new WebAppClassLoader(this);
            this.setClassLoader(classLoader);
            this._ownClassLoader = true;
        }
        if (LOG.isDebugEnabled()) {
            ClassLoader loader = this.getClassLoader();
            LOG.debug("Thread Context classloader {}", loader);
            for (loader = loader.getParent(); loader != null; loader = loader.getParent()) {
                LOG.debug("Parent class loader: {} ", loader);
            }
        }
        for (Configuration configuration : this._configurations) {
            LOG.debug("preConfigure {} with {}", this, configuration);
            configuration.preConfigure(this);
        }
    }

    public void configure() throws Exception {
        for (Configuration configuration : this._configurations) {
            LOG.debug("configure {} with {}", this, configuration);
            configuration.configure(this);
        }
    }

    public void postConfigure() throws Exception {
        for (Configuration configuration : this._configurations) {
            LOG.debug("postConfigure {} with {}", this, configuration);
            configuration.postConfigure(this);
        }
    }

    @Override
    protected void doStart() throws Exception {
        block3: {
            try {
                this._metadata.setAllowDuplicateFragmentNames(this.isAllowDuplicateFragmentNames());
                Boolean validate = (Boolean)this.getAttribute("org.eclipse.jetty.webapp.validateXml");
                this._metadata.setValidateXml(validate != null && validate != false);
                this.preConfigure();
                super.doStart();
                this.postConfigure();
                if (this.isLogUrlOnStart()) {
                    this.dumpUrl();
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed startup of context " + this, t);
                this._unavailableException = t;
                this.setAvailable(false);
                if (!this.isThrowUnavailableOnStartupException()) break block3;
                throw t;
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void destroy() {
        MultiException mx = new MultiException();
        if (this._configurations != null) {
            int i2 = this._configurations.size();
            while (i2-- > 0) {
                try {
                    this._configurations.get(i2).destroy(this);
                }
                catch (Exception e) {
                    mx.add(e);
                }
            }
        }
        this._configurations.clear();
        super.destroy();
        mx.ifExceptionThrowRuntime();
    }

    private void dumpUrl() {
        Object[] connectors = this.getServer().getConnectors();
        for (int i2 = 0; i2 < connectors.length; ++i2) {
            String displayName = this.getDisplayName();
            if (displayName == null) {
                displayName = "WebApp@" + Arrays.hashCode(connectors);
            }
            LOG.info(displayName + " at http://" + connectors[i2].toString() + this.getContextPath(), new Object[0]);
        }
    }

    @ManagedAttribute(value="configuration classes used to configure webapp", readonly=true)
    public String[] getConfigurationClasses() {
        return this._configurationClasses.toArray(new String[0]);
    }

    public Configuration[] getConfigurations() {
        return this._configurations.toArray(new Configuration[0]);
    }

    @ManagedAttribute(value="default web.xml deascriptor applied before standard web.xml", readonly=true)
    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        if (this._overrideDescriptors.size() != 1) {
            return null;
        }
        return this._overrideDescriptors.get(0);
    }

    @ManagedAttribute(value="web.xml deascriptors applied after standard web.xml", readonly=true)
    public List<String> getOverrideDescriptors() {
        return Collections.unmodifiableList(this._overrideDescriptors);
    }

    @Override
    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    @ManagedAttribute(value="classes and packages hidden by the context classloader", readonly=true)
    public String[] getServerClasses() {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        return this._serverClasses.getPatterns();
    }

    public ClasspathPattern getServerClasspathPattern() {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        return this._serverClasses;
    }

    @Deprecated
    public void addServerClass(String classOrPackageOrLocation) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        this._serverClasses.add(classOrPackageOrLocation);
    }

    @Deprecated
    public void prependServerClass(String classOrPackage) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        this._serverClasses.add(classOrPackage);
    }

    @ManagedAttribute(value="classes and packages given priority by context classloader", readonly=true)
    public String[] getSystemClasses() {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        return this._systemClasses.getPatterns();
    }

    public ClasspathPattern getSystemClasspathPattern() {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        return this._systemClasses;
    }

    @Deprecated
    public void addSystemClass(String classOrPackage) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        this._systemClasses.add(classOrPackage);
    }

    @Deprecated
    public void prependSystemClass(String classOrPackage) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        this._systemClasses.add(classOrPackage);
    }

    @Deprecated
    public boolean isServerClass(String name) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        return this._serverClasses.match(name);
    }

    @Deprecated
    public boolean isSystemClass(String name) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        return this._systemClasses.match(name);
    }

    @Override
    public boolean isServerClass(Class<?> clazz) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        boolean result = this._serverClasses.match(clazz);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isServerClass=={} {}", result, clazz);
        }
        return result;
    }

    @Override
    public boolean isSystemClass(Class<?> clazz) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        boolean result = this._systemClasses.match(clazz);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isSystemClass=={} {}", result, clazz);
        }
        return result;
    }

    @Override
    public boolean isServerResource(String name, URL parentUrl) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        boolean result = this._serverClasses.match(name, parentUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isServerResource=={} {} {}", result, name, parentUrl);
        }
        return result;
    }

    @Override
    public boolean isSystemResource(String name, URL webappUrl) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        boolean result = this._systemClasses.match(name, webappUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isSystemResource=={} {} {}", result, name, webappUrl);
        }
        return result;
    }

    protected void loadSystemClasses() {
        if (this._systemClasses != null) {
            return;
        }
        Server server = this.getServer();
        if (server != null) {
            Object systemClasses = server.getAttribute(SERVER_SYS_CLASSES);
            if (systemClasses instanceof String[]) {
                this._systemClasses = new ClasspathPattern((String[])systemClasses);
            } else if (systemClasses instanceof ClasspathPattern) {
                this._systemClasses = new ClasspathPattern(((ClasspathPattern)systemClasses).getPatterns());
            }
        }
        if (this._systemClasses == null) {
            this._systemClasses = new ClasspathPattern(__dftSystemClasses);
        }
    }

    protected void loadServerClasses() {
        if (this._serverClasses != null) {
            return;
        }
        Server server = this.getServer();
        if (server != null) {
            Object serverClasses = server.getAttribute(SERVER_SRV_CLASSES);
            if (serverClasses instanceof String[]) {
                this._serverClasses = new ClasspathPattern((String[])serverClasses);
            } else if (serverClasses instanceof ClasspathPattern) {
                this._serverClasses = new ClasspathPattern(((ClasspathPattern)serverClasses).getPatterns());
            }
        }
        if (this._serverClasses == null) {
            this._serverClasses = new ClasspathPattern(__dftServerClasses);
        }
    }

    @ManagedAttribute(value="war file location", readonly=true)
    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        if (super.getBaseResource() == null) {
            return null;
        }
        Resource webInf = super.getBaseResource().addPath("WEB-INF/");
        if (!webInf.exists() || !webInf.isDirectory()) {
            return null;
        }
        return webInf;
    }

    @ManagedAttribute(value="web application distributable")
    public boolean isDistributable() {
        return this._distributable;
    }

    @ManagedAttribute(value="extract war", readonly=true)
    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    @ManagedAttribute(value="webdir copied on deploy (allows hot replacement on windows)", readonly=true)
    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isCopyWebInf() {
        return this._copyWebInf;
    }

    @Override
    @ManagedAttribute(value="parent classloader given priority", readonly=true)
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public static String[] getDefaultConfigurationClasses() {
        return DEFAULT_CONFIGURATION_CLASSES;
    }

    public String[] getDefaultServerClasses() {
        return __dftServerClasses;
    }

    public String[] getDefaultSystemClasses() {
        return __dftSystemClasses;
    }

    protected void loadConfigurations() throws Exception {
        if (!this._configurations.isEmpty()) {
            return;
        }
        if (this._configurationClasses.isEmpty()) {
            this._configurationClasses.addAll(Configuration.ClassList.serverDefault(this.getServer()));
        }
        for (String configClass : this._configurationClasses) {
            this._configurations.add((Configuration)Loader.loadClass(configClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }

    @Override
    public String toString() {
        if (this._war != null) {
            return super.toString() + "{" + this._war + "}";
        }
        return super.toString();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        String name;
        ArrayList<String> systemClasses = null;
        if (this._systemClasses != null) {
            systemClasses = new ArrayList<String>(this._systemClasses);
            Collections.sort(systemClasses);
        }
        ArrayList<String> serverClasses = null;
        if (this._serverClasses != null) {
            serverClasses = new ArrayList<String>(this._serverClasses);
            Collections.sort(serverClasses);
        }
        if ((name = this.getDisplayName()) == null) {
            if (this._war != null) {
                int webapps = this._war.indexOf("/webapps/");
                name = webapps >= 0 ? this._war.substring(webapps + 8) : this._war;
            } else if (this.getResourceBase() != null) {
                name = this.getResourceBase();
                int webapps = name.indexOf("/webapps/");
                if (webapps >= 0) {
                    name = name.substring(webapps + 8);
                }
            } else {
                name = this.getClass().getSimpleName();
            }
        }
        name = String.format("%s@%x", name, this.hashCode());
        this.dumpObjects(out, indent, new ClassLoaderDump(this.getClassLoader()), new DumpableCollection("Systemclasses " + name, systemClasses), new DumpableCollection("Serverclasses " + name, serverClasses), new DumpableCollection("Configurations " + name, this._configurations), new DumpableCollection("Handler attributes " + name, ((AttributesMap)this.getAttributes()).getAttributeEntrySet()), new DumpableCollection("Context attributes " + name, this.getServletContext().getAttributeEntrySet()), new DumpableCollection("EventListeners " + this, Arrays.asList(this.getEventListeners())), new DumpableCollection("Initparams " + name, this.getInitParams().entrySet()));
    }

    public void setConfigurationClasses(String[] configurations) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._configurationClasses.clear();
        if (configurations != null) {
            this._configurationClasses.addAll(Arrays.asList(configurations));
        }
        this._configurations.clear();
    }

    public void setConfigurationClasses(List<String> configurations) {
        this.setConfigurationClasses(configurations.toArray(new String[0]));
    }

    public void setConfigurations(Configuration[] configurations) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._configurations.clear();
        if (configurations != null) {
            this._configurations.addAll(Arrays.asList(configurations));
        }
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.add(overrideDescriptor);
    }

    public void setOverrideDescriptors(List<String> overrideDescriptors) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.addAll(overrideDescriptors);
    }

    public void addOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.add(overrideDescriptor);
    }

    @ManagedAttribute(value="standard web.xml descriptor", readonly=true)
    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    @Override
    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        super.removeEventListener(listener);
        if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener) && this._sessionHandler != null) {
            this._sessionHandler.removeEventListener(listener);
        }
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setCopyWebDir(boolean copy) {
        this._copyDir = copy;
    }

    public void setCopyWebInf(boolean copyWebInf) {
        this._copyWebInf = copyWebInf;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setContextWhiteList(String[] contextWhiteList) {
        this._contextWhiteList = contextWhiteList;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = new ClasspathPattern(serverClasses);
    }

    public void setSystemClasses(String[] systemClasses) {
        this._systemClasses = new ClasspathPattern(systemClasses);
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.warn("EXCEPTION ", e);
            }
        }
        this._tmpDir = dir;
        this.setAttribute(TEMPDIR, this._tmpDir);
    }

    @ManagedAttribute(value="temporary directory location", readonly=true)
    public File getTempDirectory() {
        return this._tmpDir;
    }

    public void setPersistTempDirectory(boolean persist) {
        this._persistTmpDir = persist;
    }

    public boolean isPersistTempDirectory() {
        return this._persistTmpDir;
    }

    public void setWar(String war) {
        this._war = war;
    }

    public void setWarResource(Resource war) {
        this.setWar(war == null ? null : war.toString());
    }

    @Override
    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public String getExtraClasspath() {
        return this._extraClasspath;
    }

    public void setExtraClasspath(String extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean logOnStart) {
        this._logUrlOnStart = logOnStart;
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this._allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this._allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public void setThrowUnavailableOnStartupException(boolean throwIfStartupException) {
        this._throwUnavailableOnStartupException = throwIfStartupException;
    }

    public boolean isThrowUnavailableOnStartupException() {
        return this._throwUnavailableOnStartupException;
    }

    @Override
    protected void startContext() throws Exception {
        this.configure();
        this._metadata.resolve(this);
        this.startWebapp();
    }

    @Override
    protected void stopContext() throws Exception {
        this.stopWebapp();
        try {
            int i2 = this._configurations.size();
            while (i2-- > 0) {
                this._configurations.get(i2).deconfigure(this);
            }
            if (this._metadata != null) {
                this._metadata.clear();
            }
            this._metadata = new MetaData();
        }
        finally {
            if (this._ownClassLoader) {
                ClassLoader loader = this.getClassLoader();
                if (loader instanceof URLClassLoader) {
                    ((URLClassLoader)loader).close();
                }
                this.setClassLoader(null);
            }
            this.setAvailable(true);
            this._unavailableException = null;
        }
    }

    protected void startWebapp() throws Exception {
        super.startContext();
    }

    protected void stopWebapp() throws Exception {
        super.stopContext();
    }

    @Override
    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        HashSet<String> unchangedURLMappings = new HashSet<String>();
        Collection<String> pathMappings = registration.getMappings();
        if (pathMappings != null) {
            ConstraintSecurityHandler.createConstraint(registration.getName(), servletSecurityElement);
            for (String pathSpec : pathMappings) {
                Origin origin = this.getMetaData().getOrigin("constraint.url." + pathSpec);
                switch (origin) {
                    case NotSet: {
                        List<ConstraintMapping> mappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath(registration.getName(), pathSpec, servletSecurityElement);
                        for (ConstraintMapping m : mappings) {
                            ((ConstraintAware)((Object)this.getSecurityHandler())).addConstraintMapping(m);
                        }
                        ((ConstraintAware)((Object)this.getSecurityHandler())).checkPathsWithUncoveredHttpMethods();
                        this.getMetaData().setOriginAPI("constraint.url." + pathSpec);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: 
                    case WebFragment: {
                        unchangedURLMappings.add(pathSpec);
                        break;
                    }
                    case Annotation: 
                    case API: {
                        List<ConstraintMapping> constraintMappings = ConstraintSecurityHandler.removeConstraintMappingsForPath(pathSpec, ((ConstraintAware)((Object)this.getSecurityHandler())).getConstraintMappings());
                        List<ConstraintMapping> freshMappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath(registration.getName(), pathSpec, servletSecurityElement);
                        constraintMappings.addAll(freshMappings);
                        ((ConstraintSecurityHandler)this.getSecurityHandler()).setConstraintMappings(constraintMappings);
                        ((ConstraintAware)((Object)this.getSecurityHandler())).checkPathsWithUncoveredHttpMethods();
                        break;
                    }
                }
            }
        }
        return unchangedURLMappings;
    }

    public MetaData getMetaData() {
        return this._metadata;
    }

    public static void addServerClasses(Server server, String ... pattern) {
        if (pattern == null || pattern.length == 0) {
            return;
        }
        Object o = server.getAttribute(SERVER_SRV_CLASSES);
        if (o instanceof ClasspathPattern) {
            ((ClasspathPattern)o).add(pattern);
            return;
        }
        String[] serverClasses = o instanceof String[] ? (String[])o : __dftServerClasses;
        int l = serverClasses.length;
        serverClasses = Arrays.copyOf(serverClasses, l + pattern.length);
        System.arraycopy(pattern, 0, serverClasses, l, pattern.length);
        server.setAttribute(SERVER_SRV_CLASSES, serverClasses);
    }

    public static void addSystemClasses(Server server, String ... pattern) {
        if (pattern == null || pattern.length == 0) {
            return;
        }
        Object o = server.getAttribute(SERVER_SYS_CLASSES);
        if (o instanceof ClasspathPattern) {
            ((ClasspathPattern)o).add(pattern);
            return;
        }
        String[] systemClasses = o instanceof String[] ? (String[])o : __dftSystemClasses;
        int l = systemClasses.length;
        systemClasses = Arrays.copyOf(systemClasses, l + pattern.length);
        System.arraycopy(pattern, 0, systemClasses, l, pattern.length);
        server.setAttribute(SERVER_SYS_CLASSES, systemClasses);
    }

    public class Context
    extends ServletContextHandler.Context {
        @Override
        public void checkListener(Class<? extends EventListener> listener) throws IllegalStateException {
            block3: {
                try {
                    super.checkListener(listener);
                }
                catch (IllegalArgumentException e) {
                    boolean ok = false;
                    for (Class<? extends EventListener> l : SessionHandler.SESSION_LISTENER_TYPES) {
                        if (!l.isAssignableFrom(listener)) continue;
                        ok = true;
                        break;
                    }
                    if (ok) break block3;
                    throw new IllegalArgumentException("Inappropriate listener type " + listener.getName());
                }
            }
        }

        @Override
        public URL getResource(String path) throws MalformedURLException {
            Resource resource = WebAppContext.this.getResource(path);
            if (resource == null || !resource.exists()) {
                return null;
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection && !WebAppContext.this.isExtractWAR()) {
                Resource[] resources = ((ResourceCollection)resource).getResources();
                int i2 = resources.length;
                while (i2-- > 0) {
                    if (!resources[i2].getName().startsWith("jar:file")) continue;
                    return resources[i2].getURI().toURL();
                }
            }
            return resource.getURI().toURL();
        }

        @Override
        public ServletContext getContext(String uripath) {
            ServletContext servletContext = super.getContext(uripath);
            if (servletContext != null && WebAppContext.this._contextWhiteList != null) {
                for (String context : WebAppContext.this._contextWhiteList) {
                    if (!context.equals(uripath)) continue;
                    return servletContext;
                }
                return null;
            }
            return servletContext;
        }
    }
}

