/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.ui.ext.OutputUiExtension;

public class OutputUIService {
    private List<OutputUiExtension> extensions = new ArrayList<OutputUiExtension>();
    private static final Log logger = LogFactory.getLog(OutputUIService.class);

    public void setOutputUiExtensions(List<OutputUiExtension> extensions) {
        for (OutputUiExtension e : extensions) {
            this.extensions.add(e);
        }
    }

    public void addOutputUiExtension(OutputUiExtension extensionClass) {
        this.extensions.add(extensionClass);
    }

    public OutputUiExtension getUiExtension(Output outputInstance) {
        for (OutputUiExtension ext : this.extensions) {
            if (!ext.accept(outputInstance)) continue;
            logger.info((Object)("OutputUiExtension found for output type: " + outputInstance.getClass().getName()));
            return ext;
        }
        logger.warn((Object)("No OutputUiExtension found for output type: " + outputInstance.getClass().getName()));
        return null;
    }
}

