/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.ui.UIConfiguration;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class UIMain {
    private static final Log logger = LogFactory.getLog(UIMain.class);
    private UIConfiguration configuration;
    private XulLoader xulLoader;
    private XulRunner xulRunner;

    public static void main(String[] args) {
        try {
            KettleClientEnvironment.init();
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml", "plugins.xml"});
            UIMain uiMain = (UIMain)context.getBean("uiMain");
            uiMain.start((ApplicationContext)context);
        }
        catch (Throwable t) {
            logger.error((Object)"uncaught exception in main", t);
            System.exit(1);
        }
    }

    public void start(ApplicationContext context) throws XulException {
        String bundleStr = this.configuration.getResourceBundle();
        ResourceBundle bundle = null;
        if (bundleStr != null) {
            try {
                bundle = ResourceBundle.getBundle(bundleStr);
            }
            catch (MissingResourceException e) {
                logger.error((Object)("Could not load Resource Bundle: " + bundleStr));
            }
        }
        this.setLAF();
        XulDomContainer container = bundle != null ? this.xulLoader.loadXul("org/pentaho/aggdes/ui/resources/mainFrame.xul", (Object)bundle) : this.xulLoader.loadXul("org/pentaho/aggdes/ui/resources/mainFrame.xul");
        Map handlerMap = context.getBeansOfType(XulEventHandler.class);
        for (Object handler : handlerMap.values()) {
            container.addEventHandler((XulEventHandler)handler);
        }
        this.xulRunner.addContainer(container);
        this.xulRunner.initialize();
        this.xulRunner.start();
    }

    public void setConfiguration(UIConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setXulLoader(XulLoader xulLoader) {
        this.xulLoader = xulLoader;
    }

    public void setXulRunner(XulRunner xulRunner) {
        this.xulRunner = xulRunner;
    }

    private void setLAF() {
        try {
            String laf = this.configuration.getLookAndFeel();
            if (laf.equalsIgnoreCase("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (laf.equalsIgnoreCase("metal")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else if (!StringUtils.isEmpty((String)laf)) {
                UIManager.setLookAndFeel(laf);
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"error setting look and feel", (Throwable)e);
        }
    }
}

