/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.exec.impl;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.ui.exec.SqlExecutor;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcTemplateSqlExecutor
implements SqlExecutor {
    private static final Log logger = LogFactory.getLog(JdbcTemplateSqlExecutor.class);
    private static final String NL = System.getProperty("line.separator");
    private ConnectionModel connectionModel;

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public String[] removeCommentsAndSemicolons(Schema schema, String[] sql) {
        String[] newsql = new String[sql.length];
        for (int i = 0; i < sql.length; ++i) {
            newsql[i] = this.removeCommentsAndSemicolons(schema, sql[i]);
        }
        return newsql;
    }

    public String removeCommentsAndSemicolons(Schema schema, String sql) {
        if (sql == null) {
            return null;
        }
        String trimmed = sql.trim();
        String commentStart = null;
        StringBuilder sb = new StringBuilder();
        schema.getDialect().comment(sb, "");
        commentStart = sb.toString();
        if (commentStart.indexOf(NL) >= 0) {
            commentStart = commentStart.substring(0, commentStart.indexOf(NL));
        }
        String[] lines = trimmed.split(NL);
        StringBuilder newSql = new StringBuilder();
        boolean newLineNeeded = false;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(commentStart)) continue;
            if (newLineNeeded) {
                newSql.append(NL);
            }
            newSql.append(lines[i]);
            newLineNeeded = true;
        }
        String noCommentSql = newSql.toString();
        if (noCommentSql.endsWith(";")) {
            noCommentSql = noCommentSql.substring(0, noCommentSql.length() - 1);
        }
        logger.debug((Object)("clean sql: --[" + noCommentSql + "]--"));
        return noCommentSql;
    }

    @Override
    public void execute(String[] sql, SqlExecutor.ExecutorCallback callback) throws DataAccessException {
        DataAccessException exceptionDuringExecute = null;
        DatabaseMeta dbMeta = this.connectionModel.getDatabaseMeta();
        String url = null;
        try {
            url = dbMeta.getURL();
        }
        catch (KettleDatabaseException e) {
            throw new DataAccessException("DatabaseMeta problem", e){
                private static final long serialVersionUID = -3457360074729938909L;
            };
        }
        SingleConnectionDataSource ds = new SingleConnectionDataSource(url, dbMeta.getUsername(), dbMeta.getPassword(), false);
        ds.setDriverClassName(dbMeta.getDriverClass());
        final JdbcTemplate jt = new JdbcTemplate((DataSource)ds);
        DataSourceTransactionManager tsMan = new DataSourceTransactionManager((DataSource)ds);
        TransactionTemplate txTemplate = new TransactionTemplate((PlatformTransactionManager)tsMan);
        txTemplate.setPropagationBehavior(3);
        final String[] noCommentSql = this.removeCommentsAndSemicolons(this.connectionModel.getSchema(), sql);
        try {
            txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    jt.batchUpdate(noCommentSql);
                }
            });
        }
        catch (DataAccessException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"data access exception", (Throwable)e);
            }
            exceptionDuringExecute = e;
        }
        callback.executionComplete((Exception)((Object)exceptionDuringExecute));
    }
}

