/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.ext.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mondrian.olap.MondrianDef;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.pentaho.aggdes.AggDesignerException;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.model.mondrian.validate.ValidationHelper;
import org.pentaho.aggdes.ui.ext.AbstractUiExtension;
import org.pentaho.aggdes.ui.ext.SchemaProviderUiExtension;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class AbstractMondrianSchemaProvider
extends AbstractUiExtension
implements SchemaProviderUiExtension {
    private static final Log logger = LogFactory.getLog(AbstractMondrianSchemaProvider.class);
    protected List<String> validatorList;
    protected ConnectionModel connectionModel;
    protected MondrianSchemaLoader mondrianSchemaLoader;
    protected boolean continueOnValidationErrors = false;
    protected boolean selected = false;
    protected boolean enabled = false;
    protected boolean schemaDefined = false;
    protected boolean selectedEnabled = false;
    protected BindingFactory bindingFactory;

    @Override
    public void onLoad() {
        this.bindingFactory.setDocument(this.document);
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this.connectionModel, "schemaSourceSelectionEnabled", (Object)this, "enabled", new BindingConvertor[0]);
        this.bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
    }

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        bindingFactory.setDocument(this.document);
        this.bindingFactory = bindingFactory;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public void setValidatorList(List<String> validatorList) {
        this.validatorList = validatorList;
    }

    public void setMondrianSchemaLoader(MondrianSchemaLoader mondrianSchemaLoader) {
        this.mondrianSchemaLoader = mondrianSchemaLoader;
    }

    public void setContinueOnValidationErrors(boolean continueOnValidationErrors) {
        this.continueOnValidationErrors = continueOnValidationErrors;
    }

    @Override
    public boolean isSchemaDefined() {
        return this.schemaDefined;
    }

    public void setSchemaDefined(boolean schemaDefined) {
        boolean prev = this.schemaDefined;
        this.schemaDefined = schemaDefined;
        logger.debug((Object)(this.getName() + ".setSchemaDefined(" + this.schemaDefined + "): oldVal=" + prev));
        this.firePropertyChange("schemaDefined", null, schemaDefined);
    }

    public abstract String getMondrianSchemaFilename() throws AggDesignerException;

    public boolean doValidation(final String cubeName) {
        final XulDialog dialog = (XulDialog)this.document.getElementById("validationProgressDialog");
        Assert.notNull((Object)dialog, (String)"could not find element with id 'validationProgressDialog'");
        final Vector validationMessages = new Vector();
        new Thread(){

            @Override
            public void run() {
                try {
                    while (dialog.isHidden()) {
                        1.sleep(500L);
                    }
                    DatabaseMeta dbMeta = AbstractMondrianSchemaProvider.this.connectionModel.getDatabaseMeta();
                    String mondrianConnectionUrl = MessageFormat.format("Provider={0};Jdbc={1};JdbcUser={2};JdbcPassword={3};Catalog={4};JdbcDrivers={5}", "Mondrian", dbMeta.getURL(), dbMeta.getUsername(), dbMeta.getPassword(), "file:" + AbstractMondrianSchemaProvider.this.getMondrianSchemaFilename(), dbMeta.getDriverClass());
                    HashMap parameterValues = new HashMap();
                    parameterValues.put(AbstractMondrianSchemaProvider.this.mondrianSchemaLoader.getParameters().get(0), mondrianConnectionUrl);
                    parameterValues.put(AbstractMondrianSchemaProvider.this.mondrianSchemaLoader.getParameters().get(1), cubeName);
                    StringBuilder validatorClassString = new StringBuilder();
                    for (String validatorClass : AbstractMondrianSchemaProvider.this.validatorList) {
                        if (validatorClassString.length() > 0) {
                            validatorClassString.append(",");
                        }
                        validatorClassString.append(validatorClass);
                    }
                    parameterValues.put(AbstractMondrianSchemaProvider.this.mondrianSchemaLoader.getParameters().get(2), validatorClassString.toString());
                    List messages = AbstractMondrianSchemaProvider.this.mondrianSchemaLoader.validateSchema(parameterValues);
                    XulDialog dialog2 = (XulDialog)AbstractMondrianSchemaProvider.this.document.getElementById("validationProgressDialog");
                    Assert.notNull((Object)dialog2, (String)"could not find element with id 'validationProgressDialog'");
                    validationMessages.addAll(messages);
                    dialog2.hide();
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"an exception occurred", (Throwable)e);
                    }
                    dialog.hide();
                }
            }
        }.start();
        dialog.show();
        XulDialog validationDialog1 = (XulDialog)this.document.getElementById("validationDialog1");
        XulTextbox textbox = (XulTextbox)this.document.getElementById("validationMessages");
        textbox.setValue(ValidationHelper.messagesToString(validationMessages));
        validationDialog1.show();
        boolean hasErrors = ValidationHelper.hasErrors(validationMessages);
        return hasErrors;
    }

    @Override
    public Schema loadSchema(String cubeName) throws AggDesignerException {
        boolean validationHasErrors = this.doValidation(cubeName);
        if (validationHasErrors && !this.continueOnValidationErrors) {
            return null;
        }
        try {
            DatabaseMeta dbMeta = this.connectionModel.getDatabaseMeta();
            String mondrianConnectionUrl = MessageFormat.format("Provider={0};Jdbc={1};JdbcUser={2};JdbcPassword={3};Catalog={4};JdbcDrivers={5}", "Mondrian", dbMeta.getURL(), dbMeta.getUsername(), dbMeta.getPassword(), "file:" + this.getMondrianSchemaFilename(), dbMeta.getDriverClass());
            HashMap parameterValues = new HashMap();
            parameterValues.put(this.mondrianSchemaLoader.getParameters().get(0), mondrianConnectionUrl);
            parameterValues.put(this.mondrianSchemaLoader.getParameters().get(1), cubeName);
            Schema newSchema = this.mondrianSchemaLoader.createSchema(parameterValues);
            return newSchema;
        }
        catch (KettleDatabaseException e) {
            throw new AggDesignerException("Error loading Schema from Mondrian file", (Throwable)e);
        }
    }

    @Override
    public List<String> getCubeNames() throws AggDesignerException {
        ArrayList<String> cubeNames;
        try {
            MondrianDef.Schema tSchema;
            Parser xmlParser = XOMUtil.createDefaultParser();
            cubeNames = new ArrayList<String>();
            cubeNames.add(Messages.getString("select_cube", new Object[0]));
            String fileName = this.getMondrianSchemaFilename();
            if (StringUtils.isEmpty((String)fileName)) {
                throw new AggDesignerException(Messages.getString("mondrian_file_null", new Object[0]));
            }
            File mondrianSchema = new File(this.getMondrianSchemaFilename());
            if (mondrianSchema != null && mondrianSchema.exists() && mondrianSchema.isFile()) {
                FileReader schemaReader = new FileReader(mondrianSchema);
                DOMWrapper def = xmlParser.parse((Reader)schemaReader);
                tSchema = new MondrianDef.Schema(def);
                for (MondrianDef.Cube cube : tSchema.cubes) {
                    logger.debug((Object)("cube: " + cube.name));
                    cubeNames.add(cube.name);
                }
            } else {
                throw new AggDesignerException("Error loading Mondrian Schema.");
            }
            this.connectionModel.setSchemaName(tSchema.name);
        }
        catch (FileNotFoundException e) {
            throw new AggDesignerException("Schema source not found.", (Throwable)e);
        }
        catch (XOMException e) {
            throw new AggDesignerException("Error parsing schema source.", (Throwable)e);
        }
        return cubeNames;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean prev = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange("enabled", null, enabled);
        this.setSelectedEnabled(this.enabled && this.selected);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean prev = this.selected;
        this.selected = selected;
        logger.debug((Object)(this.getName() + ".setSelected(" + selected + ")"));
        this.firePropertyChange("selected", prev, selected);
        this.setSelectedEnabled(this.enabled && this.selected);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean selectedEnabled) {
        boolean prev = this.selectedEnabled;
        this.selectedEnabled = selectedEnabled;
        this.firePropertyChange("selectedEnabled", prev, selectedEnabled);
    }
}

