/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.OutputService;
import org.pentaho.aggdes.output.OutputValidationException;
import org.pentaho.aggdes.ui.OutputUIService;
import org.pentaho.aggdes.ui.ext.OutputUiExtension;
import org.pentaho.aggdes.ui.form.model.AggModel;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.model.AggListEvent;
import org.pentaho.aggdes.ui.model.AggListListener;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.model.impl.UIAggregateImpl;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;
import org.pentaho.ui.xul.stereotype.RequestHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

@Controller
public class AggController
extends AbstractXulEventHandler {
    private OutputUiExtension currentUiExtension = null;
    private OutputService outputService;
    private OutputUIService outputUIService;
    private AggModel aggModel;
    private boolean initialized = false;
    private AggList aggList;
    private BindingFactory bindingFactory;
    private static final Log logger = LogFactory.getLog(AggController.class);

    @Required
    public void setAggModel(AggModel aggModel) {
        this.aggModel = aggModel;
    }

    @Required
    public void setOutputUIService(OutputUIService outputUIService) {
        this.outputUIService = outputUIService;
    }

    @Required
    public void setOutputService(OutputService outputService) {
        this.outputService = outputService;
    }

    @Required
    public void setAggList(AggList aggList) {
        this.aggList = aggList;
    }

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    @RequestHandler
    public void onLoad() {
        this.bindingFactory.setDocument(this.document);
        this.bindingFactory.createBinding((Object)this.aggModel, "name", "aggregateName", "value", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.aggModel, "desc", "aggregateDescription", "value", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.aggModel, "dimensionRowModels", "dimtable", "elements", new BindingConvertor[0]);
        if (this.aggModel.getThinAgg() == null || !this.initialized) {
            this.removeUiExtensions();
        }
        BindingConvertor<int[], Boolean> selectedItemToBoolean = new BindingConvertor<int[], Boolean>(){

            public Boolean sourceToTarget(int[] value) {
                return value.length <= 0;
            }

            public int[] targetToSource(Boolean value) {
                return null;
            }
        };
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding("definedAggTable", "selectedRows", "aggregateName", "disabled", new BindingConvertor[]{selectedItemToBoolean});
        this.bindingFactory.createBinding("definedAggTable", "selectedRows", "aggregateDescription", "disabled", new BindingConvertor[]{selectedItemToBoolean});
        this.bindingFactory.createBinding("definedAggTable", "selectedRows", "agg_remove", "disabled", new BindingConvertor[]{selectedItemToBoolean});
        this.bindingFactory.createBinding("definedAggTable", "selectedRows", "agg_up", "disabled", new BindingConvertor[]{selectedItemToBoolean});
        this.bindingFactory.createBinding("definedAggTable", "selectedRows", "agg_down", "disabled", new BindingConvertor[]{selectedItemToBoolean});
        BindingConvertor<UIAggregate, Boolean> aggModelChangedConvertor = new BindingConvertor<UIAggregate, Boolean>(){

            public Boolean sourceToTarget(UIAggregate value) {
                return value == null;
            }

            public UIAggregate targetToSource(Boolean value) {
                return null;
            }
        };
        this.bindingFactory.createBinding((Object)this.aggModel, "thinAgg", "apply_agg_btn", "disabled", new BindingConvertor[]{aggModelChangedConvertor});
        this.bindingFactory.createBinding((Object)this.aggModel, "thinAgg", "reset_agg_btn", "disabled", new BindingConvertor[]{aggModelChangedConvertor});
        this.bindingFactory.createBinding((Object)this.aggModel, "modified", "apply_agg_btn", "!disabled", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.aggModel, "modified", "reset_agg_btn", "!disabled", new BindingConvertor[0]);
        BindingConvertor<List, Boolean> convertor = new BindingConvertor<List, Boolean>(){

            public Boolean sourceToTarget(List value) {
                logger.debug((Object)("Set button disabled : " + (value == null || value.size() <= 0)));
                return value == null || value.size() <= 0;
            }

            public List targetToSource(Boolean value) {
                return null;
            }
        };
        this.aggList.addAggListListener(new AggListListener(){

            @Override
            public void listChanged(AggListEvent e) {
                if (e.getType() == AggListEvent.Type.SELECTION_CHANGING && AggController.this.aggModel.isModified()) {
                    AggController.this.promptSaveRequired();
                }
                if (e.getType() == AggListEvent.Type.SELECTION_CHANGED) {
                    AggController.this.applyUiExtensions(AggController.this.aggList.getAgg(e.getIndex()));
                }
            }
        });
        this.aggModel.setThinAgg(new UIAggregateImpl());
        this.initialized = true;
    }

    public void applyUiExtensions(UIAggregate thinAgg) {
        if (thinAgg == null) {
            this.removeUiExtensions();
            return;
        }
        Output aggOutput = thinAgg.getOutput();
        OutputUiExtension uiExtension = this.outputUIService.getUiExtension(aggOutput);
        if (uiExtension != this.currentUiExtension) {
            this.removeUiExtensions();
        }
        if (uiExtension == null) {
            return;
        }
        if (this.currentUiExtension != uiExtension) {
            try {
                this.document.addOverlay(uiExtension.getOverlayPath());
                uiExtension.onLoad();
                this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
                this.bindingFactory.createBinding((Object)uiExtension, "modified", "apply_agg_btn", "!disabled", new BindingConvertor[0]);
                this.bindingFactory.createBinding((Object)uiExtension, "modified", "reset_agg_btn", "!disabled", new BindingConvertor[0]);
                this.currentUiExtension = uiExtension;
                this.aggModel.setCurrentUiExtension(uiExtension);
            }
            catch (Exception e) {
                logger.error((Object)"Error adding output UI extensions", (Throwable)e);
            }
        }
        this.currentUiExtension.loadOutput(aggOutput);
    }

    private void promptSaveRequired() {
        try {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setTitle(Messages.getString("AggController.SaveOutputTitle", new Object[0]));
            String message = Messages.getString("AggController.SaveOutputMessage", new Object[0]) + "\n" + Messages.getString("AggController.SaveOutputMessageSaveChanges", new Object[0]);
            msgBox.setMessage(message);
            msgBox.setButtons((Object[])new String[]{Messages.getString("save", new Object[0]), Messages.getString("do_not_save", new Object[0])});
            int id = msgBox.open();
            if (id == 0) {
                this.apply();
            } else {
                this.reset();
            }
        }
        catch (XulException e) {
            logger.error((Object)"Could not launch save prompt message dialog", (Throwable)e);
        }
    }

    private void removeUiExtensions() {
        if (this.currentUiExtension == null) {
            return;
        }
        try {
            this.document.removeOverlay(this.currentUiExtension.getOverlayPath());
        }
        catch (Exception e) {
            logger.error((Object)"Error removing output UI extensions", (Throwable)e);
        }
        this.currentUiExtension.onUnload();
        this.currentUiExtension = null;
        this.aggModel.setCurrentUiExtension(null);
    }

    @RequestHandler
    public void apply() {
        this.aggModel.synchToAgg();
        try {
            this.aggModel.getThinAgg().setOutput(this.outputService.generateDefaultOutput((Aggregate)this.aggModel.getThinAgg()));
        }
        catch (OutputValidationException e) {
            logger.error((Object)"failed to generate output", (Throwable)e);
        }
        if (this.currentUiExtension != null) {
            this.currentUiExtension.saveOutputChanges(this.aggModel.getThinAgg().getOutput());
        }
        this.aggList.aggChanged(this.aggModel.getThinAgg());
    }

    @RequestHandler
    public void reset() {
        this.aggModel.reset();
    }
}

