/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.output.CreateScriptGenerator;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.OutputService;
import org.pentaho.aggdes.output.OutputValidationException;
import org.pentaho.aggdes.output.PopulateScriptGenerator;
import org.pentaho.aggdes.output.SchemaGenerator;
import org.pentaho.aggdes.ui.Workspace;
import org.pentaho.aggdes.ui.exec.DDLExecutionCallbackService;
import org.pentaho.aggdes.ui.exec.DDLExecutionCompleteCallback;
import org.pentaho.aggdes.ui.exec.SqlExecutor;
import org.pentaho.aggdes.ui.ext.impl.MondrianFileSchemaModel;
import org.pentaho.aggdes.ui.form.controller.AggController;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

@Deprecated
@Controller
public class ExportHandler
extends AbstractXulEventHandler {
    private static final Log logger = LogFactory.getLog(ExportHandler.class);
    private static final String EMPTY_STRING = "";
    private static final String SYS_PROP_LINE_SEPARATOR = "line.separator";
    private static final String ELEM_ID_FILEDIALOG = "filedialog";
    private static final String ELEM_ID_MESSAGEBOX = "messagebox";
    private static final String ELEM_ID_EXEC_PROGRESS_DIALOG = "executeDdlDmlProgressDialog";
    private static final String ELEM_ID_EXPORT_DIALOG = "export_dialog";
    private static final String ELEM_ID_PREVIEW_DIALOG = "relationalPreviewDialog";
    private static final String ELEM_ID_DDL_FIELD = "ddlField";
    private static final String ELEM_ID_DML_FIELD = "dmlField";
    private OutputService outputService;
    private SqlExecutor ddlDmlExecutor;
    private AggList aggList;
    private AggController aggController;
    private ConnectionModel connectionModel;
    private Workspace workspace;
    private BindingFactory bindingFactory;
    private DDLExecutionCallbackService ddlExecCallbackService;
    private boolean overlayAdded = false;

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    @Required
    public void setOutputService(OutputService outputService) {
        this.outputService = outputService;
    }

    @Required
    public void setDdlDmlExecutor(SqlExecutor ddlDmlExecutor) {
        this.ddlDmlExecutor = ddlDmlExecutor;
    }

    @Required
    public void setDdlExecCallbackService(DDLExecutionCallbackService ddlExecCallbackService) {
        this.ddlExecCallbackService = ddlExecCallbackService;
    }

    public void onLoad() throws XulException {
        this.bindingFactory.setDocument(this.document);
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this.workspace, "applicationUnlocked", (Object)this, "connected", new BindingConvertor[0]);
    }

    public void openDialog() throws Exception {
        if (this.getEnabledAggs().size() == 0) {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement(ELEM_ID_MESSAGEBOX);
            msgBox.setMessage(Messages.getString("ExportHandler.NoAggsDefinedOrEnabled", new Object[0]));
            msgBox.open();
            logger.info((Object)"Exiting showRelationalPreview as there are no Aggs defined");
            return;
        }
        XulDialog dialog = (XulDialog)this.document.getElementById(ELEM_ID_EXPORT_DIALOG);
        dialog.show();
    }

    public void closeDialog() {
        XulDialog dialog = (XulDialog)this.document.getElementById(ELEM_ID_EXPORT_DIALOG);
        dialog.hide();
        this.updateAggDetails();
    }

    public void setConnected(boolean connected) throws XulException {
        Class[] classes;
        String OVERLAY = "org/pentaho/aggdes/ui/resources/exportDialogOverlay.xul";
        if (!connected) {
            this.document.removeOverlay("org/pentaho/aggdes/ui/resources/exportDialogOverlay.xul");
            this.overlayAdded = false;
            return;
        }
        boolean addOverlay = false;
        for (Class clazz : classes = this.outputService.getSupportedArtifactGeneratorClasses()) {
            if (!PopulateScriptGenerator.class.isAssignableFrom(clazz)) continue;
            addOverlay = true;
        }
        if (addOverlay && !this.overlayAdded) {
            this.document.addOverlay("org/pentaho/aggdes/ui/resources/exportDialogOverlay.xul");
            this.overlayAdded = true;
        }
    }

    public void showPreview() throws XulException {
        XulDialog previewDialog = (XulDialog)this.document.getElementById(ELEM_ID_PREVIEW_DIALOG);
        StringBuilder ddlBuf = new StringBuilder();
        List<UIAggregate> aggList = this.getEnabledAggs();
        XulTextbox ddlField = (XulTextbox)this.document.getElementById(ELEM_ID_DDL_FIELD);
        ArrayList<Output> outputs = new ArrayList<Output>();
        for (UIAggregate agg : aggList) {
            outputs.add(agg.getOutput());
        }
        if (outputs.size() > 0) {
            try {
                ddlBuf.append(this.outputService.getFullArtifact(outputs, CreateScriptGenerator.class));
            }
            catch (OutputValidationException e) {
                e.printStackTrace();
                return;
            }
            ddlField.setValue(ddlBuf.toString());
        } else {
            ddlField.setValue(EMPTY_STRING);
        }
        StringBuilder dmlBuf = new StringBuilder();
        XulTextbox dmlField = (XulTextbox)this.document.getElementById(ELEM_ID_DML_FIELD);
        if (this.document.getElementById("dml_tabpanel") != null) {
            try {
                dmlBuf.append(this.outputService.getFullArtifact(outputs, PopulateScriptGenerator.class));
            }
            catch (OutputValidationException e) {
                e.printStackTrace();
                return;
            }
            dmlField.setValue(dmlBuf.toString());
        }
        StringBuilder schemaBuf = new StringBuilder();
        XulTextbox multiDimSchemaField = (XulTextbox)this.document.getElementById("multiDimSchemaField");
        if (multiDimSchemaField != null) {
            outputs = new ArrayList();
            for (UIAggregate agg : aggList) {
                outputs.add(agg.getOutput());
            }
            try {
                schemaBuf.append(this.outputService.getFullArtifact(outputs, SchemaGenerator.class));
            }
            catch (OutputValidationException e) {
                e.printStackTrace();
                return;
            }
            multiDimSchemaField.setValue(schemaBuf.toString());
        }
        previewDialog.show();
    }

    public void hideRelationalPreview() {
        XulDialog previewDialog = (XulDialog)this.document.getElementById(ELEM_ID_PREVIEW_DIALOG);
        previewDialog.hide();
    }

    public void copyDdlToClipboard() {
        block2: {
            try {
                XulTextbox ddlField = (XulTextbox)this.document.getElementById(ELEM_ID_DDL_FIELD);
                Assert.notNull((Object)ddlField, (String)"could not find element with id 'ddlField'");
                ((XulWindow)this.document.getRootElement()).copy(ddlField.getValue());
            }
            catch (XulException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
        }
    }

    public void copyDmlToClipboard() {
        block2: {
            try {
                XulTextbox dmlField = (XulTextbox)this.document.getElementById(ELEM_ID_DML_FIELD);
                Assert.notNull((Object)dmlField, (String)"could not find element with id 'dmlField'");
                ((XulWindow)this.document.getRootElement()).copy(dmlField.getValue());
            }
            catch (XulException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
        }
    }

    public void copyToClipboardMultiDimPreview() {
        block2: {
            XulTextbox multiDimSchemaField = (XulTextbox)this.document.getElementById("multiDimSchemaField");
            try {
                ((XulWindow)this.document.getRootElement()).copy(multiDimSchemaField.getValue());
            }
            catch (XulException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
        }
    }

    public void startExecuteDdl() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"enter startExecuteDdlDml");
        }
        XulDialog dialog = (XulDialog)this.document.getElementById(ELEM_ID_EXEC_PROGRESS_DIALOG);
        Assert.notNull((Object)dialog, (String)"could not find element with id 'executeDdlDmlProgressDialog'");
        final SqlExecutor.ExecutorCallback cb = new SqlExecutor.ExecutorCallback(){

            @Override
            public void executionComplete(Exception e) {
                ExportHandler.this.done(e);
                if (ExportHandler.this.ddlExecCallbackService != null && ExportHandler.this.ddlExecCallbackService.getDdlCallbacks() != null) {
                    for (DDLExecutionCompleteCallback callback : ExportHandler.this.ddlExecCallbackService.getDdlCallbacks()) {
                        callback.executionComplete(ExportHandler.this.getEnabledAggs(), e);
                    }
                }
            }
        };
        new Thread(){

            @Override
            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"enter run");
                }
                List<String> sqls = ExportHandler.this.getOutput(true, false);
                ExportHandler.this.ddlDmlExecutor.execute(sqls.toArray(new String[0]), cb);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"exit run");
                }
            }
        }.start();
        dialog.show();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"exit startExecuteDdlDml");
        }
    }

    private void updateAggDetails() {
        if (this.aggController != null && this.aggList != null && this.aggList.getSelectedIndex() > -1) {
            this.aggController.applyUiExtensions(this.aggList.getAgg(this.aggList.getSelectedIndex()));
        }
    }

    public void startExecuteDml() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"enter startExecuteDdlDml");
        }
        XulDialog dialog = (XulDialog)this.document.getElementById(ELEM_ID_EXEC_PROGRESS_DIALOG);
        Assert.notNull((Object)dialog, (String)"could not find element with id 'executeDdlDmlProgressDialog'");
        final SqlExecutor.ExecutorCallback cb = new SqlExecutor.ExecutorCallback(){

            @Override
            public void executionComplete(Exception e) {
                ExportHandler.this.done(e);
            }
        };
        new Thread(){

            @Override
            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"enter run");
                }
                List<String> sqls = ExportHandler.this.getOutput(false, true);
                ExportHandler.this.ddlDmlExecutor.execute(sqls.toArray(new String[0]), cb);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"exit run");
                }
            }
        }.start();
        dialog.show();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"exit startExecuteDdlDml");
        }
    }

    protected List<String> getOutput(boolean exportDdl, boolean exportDml) {
        Output output;
        List<UIAggregate> aggList = this.getEnabledAggs();
        ArrayList<String> sqls = new ArrayList<String>();
        for (UIAggregate agg : aggList) {
            output = agg.getOutput();
            if (!exportDdl) continue;
            try {
                sqls.add(this.outputService.getArtifact(output, CreateScriptGenerator.class));
            }
            catch (OutputValidationException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        for (UIAggregate agg : aggList) {
            output = agg.getOutput();
            if (!exportDml) continue;
            try {
                sqls.add(this.outputService.getArtifact(output, PopulateScriptGenerator.class) + "\n\n");
            }
            catch (OutputValidationException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        return sqls;
    }

    public void done(Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"enter executeDdlDmlDone");
        }
        XulDialog dialog = (XulDialog)this.document.getElementById(ELEM_ID_EXEC_PROGRESS_DIALOG);
        Assert.notNull((Object)dialog, (String)"could not find element with id 'executeDdlDmlProgressDialog'");
        dialog.hide();
        if (null != e) {
            XulMessageBox msgBox;
            try {
                msgBox = (XulMessageBox)this.document.createElement(ELEM_ID_MESSAGEBOX);
            }
            catch (XulException e1) {
                logger.error((Object)"an exception occurred", (Throwable)e1);
                return;
            }
            msgBox.setMessage(e.getLocalizedMessage());
            msgBox.setTitle(Messages.getString("ExportHandler.DdlDmlExecutionErrorDialogTitle", new Object[0]));
            msgBox.setScrollable(true);
            msgBox.setHeight(300);
            msgBox.setWidth(400);
            msgBox.open();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"exit executeDdlDmlDone");
        }
    }

    public void saveDdl() throws XulException {
        block5: {
            XulFileDialog fc = (XulFileDialog)this.document.createElement(ELEM_ID_FILEDIALOG);
            fc.setModalParent(((XulDialog)this.document.getElementById(ELEM_ID_EXPORT_DIALOG)).getRootObject());
            XulFileDialog.RETURN_CODE retVal = fc.showSaveDialog();
            File selectedFile = null;
            if (retVal == XulFileDialog.RETURN_CODE.OK) {
                selectedFile = (File)fc.getFile();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Selected Save file: " + selectedFile.getAbsolutePath()));
                }
                StringBuilder data = new StringBuilder();
                List<String> sqls = this.getOutput(true, false);
                for (String sql : sqls) {
                    data.append(sql).append(System.getProperty(SYS_PROP_LINE_SEPARATOR));
                }
                try {
                    FileUtils.writeStringToFile((File)selectedFile, (String)data.toString());
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"an exception occurred", (Throwable)e);
                }
            }
        }
    }

    public void saveDml() throws XulException {
        block5: {
            XulFileDialog fc = (XulFileDialog)this.document.createElement(ELEM_ID_FILEDIALOG);
            fc.setModalParent(((XulDialog)this.document.getElementById(ELEM_ID_EXPORT_DIALOG)).getRootObject());
            XulFileDialog.RETURN_CODE retVal = fc.showSaveDialog();
            File selectedFile = null;
            if (retVal == XulFileDialog.RETURN_CODE.OK) {
                selectedFile = (File)fc.getFile();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Selected Save file: " + selectedFile.getAbsolutePath()));
                }
                StringBuilder data = new StringBuilder();
                List<String> sqls = this.getOutput(false, true);
                for (String sql : sqls) {
                    data.append(sql).append(System.getProperty(SYS_PROP_LINE_SEPARATOR));
                }
                try {
                    FileUtils.writeStringToFile((File)selectedFile, (String)data.toString());
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"an exception occurred", (Throwable)e);
                }
            }
        }
    }

    public File saveOlap() throws XulException {
        block9: {
            if (!(this.connectionModel.getSelectedSchemaModel() instanceof MondrianFileSchemaModel)) {
                XulMessageBox msgBox = (XulMessageBox)this.document.createElement(ELEM_ID_MESSAGEBOX);
                msgBox.setMessage("Inconsistent application state: Only MondrianFileSchemaModel should call into this method");
                msgBox.open();
                logger.error((Object)"Inconsistent application state: Only MondrianFileSchemaModel should call into this method");
                return null;
            }
            XulFileDialog fc = (XulFileDialog)this.document.createElement(ELEM_ID_FILEDIALOG);
            fc.setModalParent(((XulDialog)this.document.getElementById(ELEM_ID_EXPORT_DIALOG)).getRootObject());
            MondrianFileSchemaModel schemaModel = (MondrianFileSchemaModel)this.connectionModel.getSelectedSchemaModel();
            XulFileDialog.RETURN_CODE retVal = fc.showSaveDialog((Object)new File(schemaModel.getMondrianSchemaFilename()));
            File selectedFile = null;
            if (retVal == XulFileDialog.RETURN_CODE.OK) {
                selectedFile = (File)fc.getFile();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Selected Save file: " + selectedFile.getAbsolutePath()));
                }
                StringBuilder data = new StringBuilder();
                List<UIAggregate> aggList = this.getEnabledAggs();
                ArrayList<Output> outputs = new ArrayList<Output>();
                for (UIAggregate agg : aggList) {
                    outputs.add(agg.getOutput());
                }
                try {
                    data.append(this.outputService.getFullArtifact(outputs, SchemaGenerator.class));
                }
                catch (OutputValidationException e1) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"an exception occurred", (Throwable)e1);
                    }
                    return null;
                }
                try {
                    FileUtils.writeStringToFile((File)selectedFile, (String)data.toString());
                    schemaModel.setMondrianSchemaFilename(selectedFile.getCanonicalPath());
                    this.connectionModel.setSchemaUpToDate(true);
                    return selectedFile;
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) break block9;
                    logger.error((Object)"an exception occurred", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Required
    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public AggList getAggList() {
        return this.aggList;
    }

    public List<UIAggregate> getEnabledAggs() {
        ArrayList<UIAggregate> enabledAggs = new ArrayList<UIAggregate>();
        for (UIAggregate agg : this.getAggList()) {
            if (!agg.getEnabled()) continue;
            enabledAggs.add(agg);
        }
        return enabledAggs;
    }

    public void setAggList(AggList aggList) {
        this.aggList = aggList;
    }

    @Required
    public void setAggController(AggController aggController) {
        this.aggController = aggController;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

