/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;

@Controller
public class StatusController
extends AbstractXulEventHandler {
    private ConnectionModel connectionModel;
    private static final Log logger = LogFactory.getLog(StatusController.class);
    private StatusModel statusModel = new StatusModel();
    private BindingFactory bindingFactory;

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    public void onLoad() {
        this.bindingFactory.setDocument(this.document);
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this.connectionModel, "cubeName", (Object)this.statusModel, "cubeName", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.connectionModel, "schemaName", (Object)this.statusModel, "schemaName", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.connectionModel, "databaseName", (Object)this.statusModel, "databaseName", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.statusModel, "statusMessage", (Object)this.document.getElementById("statusMessage"), "value", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.connectionModel, "schema", (Object)this.statusModel, "connected", new BindingConvertor[]{new BindingConvertor<Schema, Boolean>(){

            public Boolean sourceToTarget(Schema value) {
                return value != null;
            }

            public Schema targetToSource(Boolean value) {
                return null;
            }
        }});
        this.bindingFactory.createBinding((Object)this.statusModel, "connected", (Object)this.document.getElementById("connectionImage"), "image", new BindingConvertor[]{new BindingConvertor<Boolean, String>(){

            public String sourceToTarget(Boolean connected) {
                return connected != false ? "images/ok.png" : "images/disconnected.png";
            }

            public Boolean targetToSource(String arg0) {
                return null;
            }
        }});
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public class StatusModel
    extends XulEventSourceAdapter {
        private String databaseName;
        private String schemaName;
        private String cubeName;
        private boolean connected = false;

        public String getStatusMessage() {
            return String.format("%s      %s      %s", !StringUtils.isEmpty((String)this.databaseName) ? Messages.getString("database", new Object[0]) + ": " + this.databaseName : "", !StringUtils.isEmpty((String)this.schemaName) ? Messages.getString("schema", new Object[0]) + ": " + this.schemaName : "", !StringUtils.isEmpty((String)this.cubeName) ? Messages.getString("cube", new Object[0]) + ": " + this.cubeName : "");
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            this.firePropertyChange("statusMessage", null, this.getStatusMessage());
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            this.firePropertyChange("statusMessage", null, this.getStatusMessage());
        }

        public String getCubeName() {
            return this.cubeName;
        }

        public void setCubeName(String cubeName) {
            if (cubeName == null || cubeName.equals(Messages.getString("select_cube", new Object[0]))) {
                cubeName = "";
            }
            this.cubeName = cubeName;
            this.firePropertyChange("statusMessage", null, this.getStatusMessage());
        }

        public void setConnected(boolean bool) {
            this.connected = bool;
            this.firePropertyChange("connected", null, bool);
        }

        public boolean getConnected() {
            return this.connected;
        }
    }
}

