/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dimension;
import org.pentaho.aggdes.model.Level;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.ui.ext.OutputUiExtension;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.form.model.DimensionRowModel;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.model.impl.UIAggregateImpl;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.FormModel;

@FormModel
public class AggModel
extends XulEventSourceAdapter {
    private UIAggregate thinAgg = new UIAggregateImpl();
    private OutputUiExtension currentUiExtension = null;
    private List<DimensionRowModel> dimensionRowModels = new ArrayList<DimensionRowModel>();
    private List<? extends Level> levels;
    private static final Log logger = LogFactory.getLog(AggModel.class);
    private String name;
    private String desc;
    private boolean modified;
    private Algorithm algorithm;
    private ConnectionModel connectionModel;

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setCurrentUiExtension(OutputUiExtension currentUiExtension) {
        this.currentUiExtension = currentUiExtension;
    }

    public boolean isModified() {
        return this.modified || this.currentUiExtension != null && this.currentUiExtension.isModified();
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.firePropertyChange("modified", null, modified);
    }

    public UIAggregate getThinAgg() {
        return this.thinAgg;
    }

    public void setThinAgg(UIAggregate thinAgg) {
        if (thinAgg == null) {
            this.clearForm();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setThinAgg(" + thinAgg + ")"));
            logger.debug((Object)("       agg name: " + thinAgg.getName()));
            logger.debug((Object)("agg description: " + thinAgg.getName()));
            logger.debug((Object)("       agg type: " + (thinAgg.isAlgoAgg() ? Messages.getString("agg_type_advisor", new Object[0]) : Messages.getString("agg_type_custom", new Object[0]))));
            logger.debug((Object)"     attributes:");
            for (Attribute attrib : thinAgg.getAttributes()) {
                logger.debug((Object)("                " + attrib.getLabel()));
            }
        }
        ArrayList<DimensionRowModel> newDimensionRowModels = new ArrayList<DimensionRowModel>();
        this.thinAgg = thinAgg;
        this.setName(thinAgg.getName());
        this.setDesc(thinAgg.getDescription());
        this.firePropertyChange("name", null, this.name);
        this.firePropertyChange("desc", null, this.desc);
        if (this.connectionModel.getSchema() != null) {
            for (Dimension dim : this.connectionModel.getSchema().getDimensions()) {
                DimensionRowModel rowModel = new DimensionRowModel();
                rowModel.setDimension(dim);
                newDimensionRowModels.add(rowModel);
                rowModel.addPropertyChangeListener("selectedIndex", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        AggModel.this.setModified(true);
                    }
                });
                rowModel.initSelected(thinAgg.getAttributes());
            }
            logger.debug((Object)("calling setDimensionRowModels with " + newDimensionRowModels));
            this.setDimensionRowModels(newDimensionRowModels);
        }
        this.setModified(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldVal = this.name;
        this.name = name;
        this.setModified(true);
        this.firePropertyChange("name", oldVal, name);
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        String oldVal = this.desc;
        this.desc = desc;
        this.setModified(true);
        this.firePropertyChange("desc", oldVal, desc);
    }

    public List<DimensionRowModel> getDimensionRowModels() {
        return this.dimensionRowModels;
    }

    public void setDimensionRowModels(List<DimensionRowModel> dimensionRowModels) {
        this.dimensionRowModels = dimensionRowModels;
        this.setModified(true);
        this.firePropertyChange("dimensionRowModels", null, dimensionRowModels);
    }

    public void clearForm() {
        logger.debug((Object)"clearForm()");
        this.setName("");
        this.setDesc("");
        this.setDimensionRowModels(new ArrayList<DimensionRowModel>());
        this.setModified(false);
    }

    public void reset() {
        this.setThinAgg(this.thinAgg);
        if (this.currentUiExtension != null) {
            this.currentUiExtension.loadOutput(this.thinAgg.getOutput());
        }
    }

    public void synchToAgg() {
        this.thinAgg.setName(this.name);
        this.thinAgg.setDescription(this.desc);
        this.thinAgg.setAlgoAgg(false);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (DimensionRowModel row : this.dimensionRowModels) {
            int insertPoint = attributes.size();
            for (Level level = row.getSelectedItem(); level != null; level = level.getParent()) {
                logger.debug((Object)("selected item is " + level.getName()));
                Attribute attrib = level.getAttribute();
                if (attrib == null) continue;
                logger.debug((Object)("adding level " + level.getName() + " to UIAggregate: " + this.thinAgg));
                if (attributes.contains(attrib)) continue;
                attributes.add(insertPoint, attrib);
            }
        }
        this.thinAgg.setAttributes(attributes);
        ArrayList<Measure> measures = new ArrayList<Measure>();
        if (this.connectionModel != null) {
            measures.addAll(this.connectionModel.getSchema().getMeasures());
        }
        this.thinAgg.setMeasures(measures);
        this.setModified(false);
        if (this.connectionModel != null) {
            Aggregate algoAggregate = this.algorithm.createAggregate(this.connectionModel.getSchema(), this.thinAgg.getAttributes());
            this.thinAgg.setEstimateRowCount(algoAggregate.estimateRowCount());
            this.thinAgg.setEstimateSpace(algoAggregate.estimateSpace());
        }
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }
}

