/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.aggdes.AggDesignerException;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.model.SchemaModel;
import org.pentaho.aggdes.ui.util.AggListConverter;
import org.pentaho.aggdes.ui.util.AttributeConverter;
import org.pentaho.aggdes.ui.util.DatabaseMetaConverter;
import org.pentaho.aggdes.ui.util.MeasureConverter;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.di.core.database.DatabaseMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SerializationService {
    private final String SERIALIZATION_VERSION = "1.0";
    private ConnectionModel connectionModel;
    private AggList aggList;

    public String[] getConnectionAndAggListElements(String xml) throws AggDesignerException {
        try {
            String[] xmlElements = new String[3];
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes()));
            int c = -1;
            for (int i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
                Node node = doc.getDocumentElement().getChildNodes().item(i);
                if (!(node instanceof Element)) continue;
                if (c == 3) {
                    throw new RuntimeException("Failed to parseWorkspace, extra elements found");
                }
                DOMSource source = new DOMSource(node);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.transform(source, result);
                if (c == -1) {
                    XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
                    String versionInfo = writer.toString();
                    String serializationVersion = (String)xstream.fromXML(versionInfo);
                    if (!serializationVersion.equals("1.0")) {
                        throw new AggDesignerException(Messages.getString("SerializationService.UnrecognizedVersion", "1.0", serializationVersion));
                    }
                    ++c;
                    continue;
                }
                xmlElements[c++] = writer.toString();
            }
            return xmlElements;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to parse Workspace");
        }
        catch (Exception e) {
            if (e instanceof AggDesignerException) {
                AggDesignerException ex = (AggDesignerException)e;
                throw ex;
            }
            e.printStackTrace();
            throw new RuntimeException("Failed to parse Workspace");
        }
    }

    private XStream getXStream(Schema schema) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.registerConverter((Converter)new DatabaseMetaConverter());
        xstream.registerConverter((Converter)new AggListConverter(this.aggList));
        xstream.registerConverter((Converter)new AttributeConverter(schema));
        xstream.registerConverter((Converter)new MeasureConverter(schema));
        return xstream;
    }

    public String serializeWorkspace(Schema schema) {
        this.connectionModel.getSelectedSchemaModel().setSchemaChecksum(this.connectionModel.getSelectedSchemaModel().recalculateSchemaChecksum());
        ArrayList<Object> systemObjects = new ArrayList<Object>();
        AggList aggList = this.getAggList();
        XStream xstream = this.getXStream(schema);
        systemObjects.add("1.0");
        systemObjects.add(this.connectionModel.getDatabaseMeta());
        systemObjects.add(this.connectionModel.getSelectedSchemaModel());
        systemObjects.add(aggList);
        return xstream.toXML(systemObjects);
    }

    public void deserializeConnection(Schema schema, String rdbmsXml, String schemaXml) {
        XStream xstream = this.getXStream(schema);
        DatabaseMeta databaseMeta = (DatabaseMeta)xstream.fromXML(rdbmsXml);
        SchemaModel schemaModel = (SchemaModel)xstream.fromXML(schemaXml);
        String cubeName = schemaModel.getCubeName();
        this.connectionModel.setDatabaseMeta(databaseMeta);
        this.connectionModel.setSelectedSchemaModel(schemaModel);
        this.connectionModel.setCubeName(cubeName);
    }

    public void deserializeAggList(Schema schema, String xml) {
        XStream xstream = this.getXStream(schema);
        xstream.fromXML(xml);
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public AggList getAggList() {
        return this.aggList;
    }

    public void setAggList(AggList aggList) {
        this.aggList = aggList;
    }
}

