/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import java.util.List;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import org.pentaho.aggdes.Main;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dialect;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.mondrian.MondrianDialect;
import org.pentaho.aggdes.model.mondrian.MondrianSchemaLoader;
import org.pentaho.aggdes.model.mondrian.MondrianTable;

public class MondrianMeasure
implements Measure {
    private final MondrianTable table;
    private final RolapStar.Measure measure;

    public MondrianMeasure(MondrianTable table, RolapStar.Measure measure) {
        this.table = table;
        this.measure = measure;
    }

    public RolapStar.Measure getRolapStarMeasure() {
        return this.measure;
    }

    @Override
    public boolean isDistinct() {
        return this.measure.getAggregator().isDistinct();
    }

    @Override
    public String getLabel() {
        return this.table.getLabel() + "." + this.measure.getName();
    }

    @Override
    public MondrianTable getTable() {
        return this.table;
    }

    @Override
    public double estimateSpace() {
        return MondrianSchemaLoader.estimateSpaceForColumn((RolapStar.Column)this.measure);
    }

    @Override
    public String getCandidateColumnName() {
        return Main.depunctify(this.getLabel());
    }

    @Override
    public String getDatatype(Dialect dialect) {
        RolapAggregator aggregator = this.measure.getAggregator();
        String aggregatorName = aggregator.getName().toUpperCase();
        mondrian.spi.Dialect mondrianDialect = ((MondrianDialect)dialect).getMondrianDialect();
        if (aggregator == RolapAggregator.Min || aggregator == RolapAggregator.Max) {
            return this.measure.getDatatypeString(mondrianDialect);
        }
        if (aggregator == RolapAggregator.Count || aggregator == RolapAggregator.DistinctCount) {
            return dialect.getIntegerTypeString();
        }
        if (aggregator == RolapAggregator.Sum || aggregator == RolapAggregator.Avg) {
            return dialect.getDoubleTypeString();
        }
        throw new RuntimeException("Unknown aggregator " + aggregatorName);
    }

    @Override
    public List<Attribute> getAncestorAttributes() {
        return null;
    }
}

