/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.output.impl;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.ArtifactGenerator;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.OutputFactory;
import org.pentaho.aggdes.output.OutputService;
import org.pentaho.aggdes.output.OutputValidationException;

public class OutputServiceImpl
implements OutputService {
    private Schema schema;
    private List<ArtifactGenerator> artifactGenerators = new ArrayList<ArtifactGenerator>();
    private List<OutputFactory> outputFactories = new ArrayList<OutputFactory>();
    static int k = 0;

    public OutputServiceImpl() {
    }

    public void setOutputFactories(List<OutputFactory> outputFactories) {
        this.outputFactories = outputFactories;
    }

    public void setArtifactGenerators(List<ArtifactGenerator> artifactGenerators) {
        this.artifactGenerators = artifactGenerators;
    }

    public List<OutputFactory> getOutputFactories() {
        return this.outputFactories;
    }

    public List<ArtifactGenerator> getArtifactGenerators() {
        return this.artifactGenerators;
    }

    public OutputServiceImpl(Schema schema) {
        this();
        this.schema = schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    private boolean containsSupportedOutputClass(Class<? extends Object> objectClass, Class<? extends Object>[] objectClasses) {
        for (Class<? extends Object> clazz : objectClasses) {
            if (!objectClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public Class<? extends ArtifactGenerator>[] getSupportedArtifactGeneratorClasses() {
        ArrayList list = new ArrayList();
        for (OutputFactory factory : this.outputFactories) {
            if (!factory.canCreateOutput(this.schema)) continue;
            for (ArtifactGenerator generator : this.artifactGenerators) {
                if (!this.containsSupportedOutputClass(factory.getOutputClass(), generator.getSupportedOutputClasses()) || list.contains(generator)) continue;
                list.add(generator.getClass());
            }
        }
        return list.toArray(new Class[0]);
    }

    private boolean isOutputCompatible(Output output, Class<? extends Output>[] clazzes) {
        for (Class<? extends Output> clazz : clazzes) {
            if (!clazz.isAssignableFrom(output.getClass())) continue;
            return true;
        }
        return false;
    }

    private ArtifactGenerator getArtifactGenerator(Class<? extends ArtifactGenerator> artifactGenerator, Output output) {
        for (int i = 0; i < this.artifactGenerators.size(); ++i) {
            if (!artifactGenerator.isAssignableFrom(this.artifactGenerators.get(i).getClass()) || !this.isOutputCompatible(output, this.artifactGenerators.get(i).getSupportedOutputClasses()) || !this.artifactGenerators.get(i).canGenerate(this.schema, output)) continue;
            return this.artifactGenerators.get(i);
        }
        return null;
    }

    @Override
    public String getArtifact(Output output, Class<? extends ArtifactGenerator> artifactGenerator) throws OutputValidationException {
        if (output == null) {
            throw new OutputValidationException("No Output Provided");
        }
        if (artifactGenerator == null) {
            throw new OutputValidationException("No Generator Provided");
        }
        ArtifactGenerator generator = this.getArtifactGenerator(artifactGenerator, output);
        if (generator == null) {
            throw new OutputValidationException("Failed to locate generator of type " + artifactGenerator + " compatible with output " + output);
        }
        return generator.generate(this.schema, output);
    }

    @Override
    public String getFullArtifact(List<? extends Output> outputs, Class<? extends ArtifactGenerator> artifactGenerator) throws OutputValidationException {
        if (outputs == null || outputs.size() == 0) {
            throw new OutputValidationException("No Output Provided");
        }
        if (artifactGenerator == null) {
            throw new OutputValidationException("No Generator Provided");
        }
        ArtifactGenerator generator = this.getArtifactGenerator(artifactGenerator, outputs.get(0));
        if (generator == null) {
            throw new OutputValidationException("Failed to locate generator of type " + artifactGenerator);
        }
        for (Output output : outputs) {
            if (generator.canGenerate(this.schema, output)) continue;
            throw new OutputValidationException("Generator " + generator.getClass().getName() + " cannot generate output " + output.toString() + " .  Unable to generate full artifact.");
        }
        return generator.generateFull(this.schema, outputs);
    }

    @Override
    public Output generateDefaultOutput(Aggregate aggregate) throws OutputValidationException {
        if (aggregate == null) {
            throw new OutputValidationException("No Aggregate Provided.");
        }
        for (OutputFactory factory : this.outputFactories) {
            if (!factory.canCreateOutput(this.schema)) continue;
            return factory.createOutput(this.schema, aggregate);
        }
        throw new OutputValidationException("Failed to locate Output Factory.");
    }

    @Override
    public void init(Schema schema) {
        this.setSchema(schema);
    }
}

