/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.vfs.provider;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.pentaho.di.connections.vfs.provider.ConnectionFileName;
import org.pentaho.di.connections.vfs.provider.ConnectionFileSystem;

public class ConnectionFileObject
extends AbstractFileObject<ConnectionFileSystem> {
    public static final String DELIMITER = "/";
    private final AbstractFileObject resolvedFileObject;
    private final String domain;

    public ConnectionFileObject(AbstractFileName name, ConnectionFileSystem fs, AbstractFileObject resolvedFileObject, String domain) {
        super(name, (AbstractFileSystem)fs);
        this.resolvedFileObject = resolvedFileObject;
        this.domain = domain;
    }

    protected long doGetContentSize() throws Exception {
        return 0L;
    }

    protected InputStream doGetInputStream() throws Exception {
        return null;
    }

    protected FileType doGetType() throws Exception {
        return null;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }

    public boolean canRenameTo(FileObject newfile) {
        return this.resolvedFileObject.canRenameTo(newfile);
    }

    public void close() throws FileSystemException {
        this.resolvedFileObject.close();
    }

    public void copyFrom(FileObject file, FileSelector selector) throws FileSystemException {
        this.resolvedFileObject.copyFrom(file, selector);
    }

    public void createFile() throws FileSystemException {
        this.resolvedFileObject.createFile();
    }

    public void createFolder() throws FileSystemException {
        this.resolvedFileObject.createFolder();
    }

    public boolean delete() throws FileSystemException {
        return this.resolvedFileObject.delete();
    }

    public int delete(FileSelector selector) throws FileSystemException {
        return this.resolvedFileObject.delete(selector);
    }

    public int deleteAll() throws FileSystemException {
        return this.resolvedFileObject.deleteAll();
    }

    public boolean exists() throws FileSystemException {
        if (this.resolvedFileObject == null) {
            return false;
        }
        return this.resolvedFileObject.exists();
    }

    public FileObject getChild(String name) throws FileSystemException {
        return this.getChild(this.resolvedFileObject.getChild(name));
    }

    public FileObject[] getChildren() throws FileSystemException {
        FileObject[] resolvedChildren = this.resolvedFileObject.getChildren();
        FileObject[] children = new FileObject[resolvedChildren.length];
        for (int i = 0; i < resolvedChildren.length; ++i) {
            children[i] = this.getChild(resolvedChildren[i]);
        }
        return children;
    }

    private FileObject getChild(FileObject fileObject) throws FileSystemException {
        String connectionName = ((ConnectionFileName)this.getName()).getConnection();
        StringBuilder connectionPath = new StringBuilder();
        connectionPath.append("pvfs");
        connectionPath.append("://");
        connectionPath.append(connectionName);
        connectionPath.append(DELIMITER);
        if (this.domain == null || this.domain.equals("")) {
            if (fileObject.getName() instanceof URLFileName) {
                URLFileName urlFileName = (URLFileName)fileObject.getName();
                connectionPath.append(urlFileName.getHostName());
            } else {
                connectionPath.append(fileObject.getURL().getHost());
            }
        }
        connectionPath.append(fileObject.getName().getPath());
        return this.resolveFile(connectionPath.toString());
    }

    public FileContent getContent() throws FileSystemException {
        return this.resolvedFileObject.getContent();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        return this.resolvedFileObject.getFileOperations();
    }

    public InputStream getInputStream() throws FileSystemException {
        return this.resolvedFileObject.getInputStream();
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.resolvedFileObject.getOutputStream();
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        return this.resolvedFileObject.getOutputStream(bAppend);
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        return this.resolvedFileObject.getRandomAccessContent(mode);
    }

    public FileType getType() throws FileSystemException {
        return this.resolvedFileObject.getType();
    }

    public void holdObject(Object strongRef) {
        this.resolvedFileObject.holdObject(strongRef);
    }

    public boolean isAttached() {
        return this.resolvedFileObject.isAttached();
    }

    public boolean isContentOpen() {
        return this.resolvedFileObject.isContentOpen();
    }

    public boolean isExecutable() throws FileSystemException {
        return this.resolvedFileObject.isExecutable();
    }

    public boolean isFile() throws FileSystemException {
        return this.resolvedFileObject.isFile();
    }

    public boolean isFolder() throws FileSystemException {
        return this.resolvedFileObject.isFolder();
    }

    public boolean isHidden() throws FileSystemException {
        return this.resolvedFileObject.isHidden();
    }

    public boolean isReadable() throws FileSystemException {
        return this.resolvedFileObject.isReadable();
    }

    public boolean isWriteable() throws FileSystemException {
        return this.resolvedFileObject.isWriteable();
    }

    public void moveTo(FileObject destFile) throws FileSystemException {
        this.resolvedFileObject.moveTo(destFile);
    }

    public void refresh() throws FileSystemException {
        if (this.resolvedFileObject != null) {
            this.resolvedFileObject.refresh();
        }
    }

    public FileObject getResolvedFileObject() {
        return this.resolvedFileObject;
    }
}

