/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.TreePath;
import mondrian.gui.I18n;
import mondrian.gui.JdbcExplorer;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.QueryPanel;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.WorkbenchMenubarPlugin;
import mondrian.olap.DriverManager;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.server.MondrianServerRegistry;
import mondrian.util.UnionIterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swing.SwingXulLoader;

public class Workbench
extends JFrame {
    private static final long serialVersionUID = 1L;
    static String WORKBENCH_USER_HOME_DIR;
    static String WORKBENCH_CONFIG_FILE;
    static String DB_META_CONFIG_FILE;
    private static final String LAST_USED1 = "lastUsed1";
    private static final String LAST_USED1_URL = "lastUsedUrl1";
    private static final String LAST_USED2 = "lastUsed2";
    private static final String LAST_USED2_URL = "lastUsedUrl2";
    private static final String LAST_USED3 = "lastUsed3";
    private static final String LAST_USED3_URL = "lastUsedUrl3";
    private static final String LAST_USED4 = "lastUsed4";
    private static final String LAST_USED4_URL = "lastUsedUrl4";
    private static final String WorkbenchInfoResourceName = "mondrian.gui.resources.workbenchInfo";
    private static final String GUIResourceName = "mondrian.gui.resources.gui";
    private static final String TextResourceName = "mondrian.gui.resources.text";
    private static final String FILTER_SCHEMA_LIST = "FILTER_SCHEMA_LIST";
    private static final Logger LOGGER;
    private String jdbcDriverClassName;
    private String jdbcConnectionUrl;
    private String jdbcUsername;
    private String jdbcPassword;
    private String jdbcSchema;
    private boolean requireSchema;
    private JdbcMetaData jdbcMetaData;
    private final ClassLoader myClassLoader;
    private Properties workbenchProperties;
    private static ResourceBundle workbenchResourceBundle;
    private static I18n resourceConverter;
    private static int newSchema;
    private String openFile = null;
    private Map<JInternalFrame, JMenuItem> schemaWindowMap = new HashMap<JInternalFrame, JMenuItem>();
    private final List<JInternalFrame> mdxWindows = new ArrayList<JInternalFrame>();
    private final List<JInternalFrame> jdbcWindows = new ArrayList<JInternalFrame>();
    private int windowMenuMapIndex = 1;
    private static final String KETTLE_PLUGIN_BASE_FOLDERS;
    private XulDialog connectionDialog = null;
    private DataHandler connectionDialogController = null;
    private DatabaseMeta dbMeta = null;
    private JButton toolbarSaveAsButton;
    private JMenuItem openMenuItem;
    private JMenuItem lastUsed1MenuItem;
    private JMenuItem lastUsed2MenuItem;
    private JMenuItem lastUsed3MenuItem;
    private JMenuItem lastUsed4MenuItem;
    private JMenu fileMenu;
    private JMenuItem newQueryMenuItem;
    private JMenuItem newQueryMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton toolbarOpenButton;
    private JButton toolbarNewButton;
    private JButton toolbarNewArrowButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JMenuItem cutMenuItem;
    private JMenuBar menuBar;
    private JMenuItem saveMenuItem;
    private JMenuItem newJDBCExplorerMenuItem;
    private JMenuItem newJDBCExplorerMenuItem2;
    private JButton toolbarSaveButton;
    private JMenuItem copyMenuItem;
    private JDesktopPane desktopPane;
    private JMenu viewMenu;
    private JMenu toolsMenu;
    private JMenu newMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem newSchemaMenuItem;
    private JMenuItem newSchemaMenuItem2;
    private JMenuItem exitMenuItem;
    private JButton toolbarPreferencesButton;
    private JCheckBoxMenuItem requireSchemaCheckboxMenuItem;
    private JMenu editMenu;
    private JMenuItem pasteMenuItem;
    private JMenuItem preferencesMenuItem;
    private JCheckBoxMenuItem viewXmlMenuItem;
    private JMenuItem saveAsMenuItem;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JPopupMenu toolbarNewPopupMenu;
    private JMenu windowMenu;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JMenuItem cascadeMenuItem;
    private JMenuItem tileMenuItem;
    private JMenuItem minimizeMenuItem;
    private JMenuItem maximizeMenuItem;
    private JMenuItem closeAllMenuItem;

    public Workbench() {
        this.myClassLoader = this.getClass().getClassLoader();
        resourceConverter = Workbench.getGlobalResourceConverter();
        WORKBENCH_USER_HOME_DIR = System.getProperty("user.home") + File.separator + ".schemaWorkbench";
        WORKBENCH_CONFIG_FILE = WORKBENCH_USER_HOME_DIR + File.separator + "workbench.properties";
        DB_META_CONFIG_FILE = WORKBENCH_USER_HOME_DIR + File.separator + "databaseMeta.xml";
        this.loadWorkbenchProperties();
        this.loadDatabaseMeta();
        this.initOptions();
        this.initComponents();
        this.loadMenubarPlugins();
        ImageIcon icon = new ImageIcon(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("productIcon")));
        this.setIconImage(icon.getImage());
    }

    public static I18n getGlobalResourceConverter() {
        if (resourceConverter == null) {
            ClassLoader currentClassLoader = Workbench.class.getClassLoader();
            ResourceBundle localGuiResourceBundle = ResourceBundle.getBundle(GUIResourceName, Locale.getDefault(), currentClassLoader);
            ResourceBundle localTextResourceBundle = ResourceBundle.getBundle(TextResourceName, Locale.getDefault(), currentClassLoader);
            resourceConverter = new I18n(localGuiResourceBundle, localTextResourceBundle);
        }
        return resourceConverter;
    }

    private void loadWorkbenchProperties() {
        this.workbenchProperties = new Properties();
        try {
            workbenchResourceBundle = ResourceBundle.getBundle(WorkbenchInfoResourceName, Locale.getDefault(), this.myClassLoader);
            File f = new File(WORKBENCH_CONFIG_FILE);
            if (f.exists()) {
                this.workbenchProperties.load(new FileInputStream(f));
            } else {
                LOGGER.debug((Object)(WORKBENCH_CONFIG_FILE + " does not exist"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"loadWorkbenchProperties", (Throwable)e);
        }
    }

    public void loadDatabaseMeta() {
        File file;
        if (this.dbMeta == null && (file = new File(DB_META_CONFIG_FILE)).exists()) {
            try {
                String fileContents = FileUtils.readFileToString((File)file);
                if (Util.isBlank((String)fileContents)) {
                    LOGGER.error((Object)("DB Meta file is empty at: " + DB_META_CONFIG_FILE));
                } else {
                    this.dbMeta = this.getDbMeta(fileContents);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to load DB meta file at: " + DB_META_CONFIG_FILE), (Throwable)e);
            }
        }
        if (this.dbMeta != null) {
            this.syncToWorkspace(this.dbMeta);
        }
    }

    public String getWorkbenchProperty(String key) {
        return this.workbenchProperties.getProperty(key);
    }

    public void setWorkbenchProperty(String key, String value) {
        this.workbenchProperties.setProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWorkbenchProperties() {
        File dir = new File(WORKBENCH_USER_HOME_DIR);
        try {
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.user.home.not.directory", "{0} is not a directory!\nPlease rename this file and retry to save configuration!", WORKBENCH_USER_HOME_DIR), "", 0);
                    return;
                }
            } else {
                dir.mkdirs();
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"storeWorkbenchProperties: mkdirs", (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.user.home.exception", "An error is occurred creating workbench configuration directory:\n{0}\nError is: {1}", WORKBENCH_USER_HOME_DIR, ex.getLocalizedMessage()), "", 0);
            return;
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(WORKBENCH_CONFIG_FILE));
            this.workbenchProperties.store(out, "Workbench configuration");
        }
        catch (Exception e) {
            LOGGER.error((Object)"storeWorkbenchProperties: store", (Throwable)e);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.save.configuration", "An error is occurred creating workbench configuration file:\n{0}\nError is: {1}", WORKBENCH_CONFIG_FILE, e.getLocalizedMessage()), "", 0);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException eIO) {
                LOGGER.error((Object)"storeWorkbenchProperties: out.close", (Throwable)eIO);
            }
        }
    }

    public void storeDatabaseMeta() {
        if (this.dbMeta != null) {
            try {
                File file = new File(DB_META_CONFIG_FILE);
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                pw.println(this.dbMeta.getXML());
                pw.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"storeDatabaseMeta", (Throwable)e);
            }
        }
    }

    private void initOptions() {
        this.requireSchema = "true".equals(this.getWorkbenchProperty("requireSchema"));
    }

    private void initComponents() {
        this.desktopPane = new JDesktopPane();
        this.jToolBar1 = new JToolBar();
        this.jToolBar2 = new JToolBar();
        this.toolbarNewPopupMenu = new JPopupMenu();
        this.toolbarNewButton = new JButton();
        this.toolbarOpenButton = new JButton();
        this.toolbarSaveButton = new JButton();
        this.toolbarSaveAsButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.toolbarPreferencesButton = new JButton();
        this.requireSchemaCheckboxMenuItem = new JCheckBoxMenuItem();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenu = new JMenu();
        this.newSchemaMenuItem = new JMenuItem();
        this.newQueryMenuItem = new JMenuItem();
        this.newJDBCExplorerMenuItem = new JMenuItem();
        this.newSchemaMenuItem2 = new JMenuItem();
        this.newQueryMenuItem2 = new JMenuItem();
        this.newJDBCExplorerMenuItem2 = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.preferencesMenuItem = new JMenuItem();
        this.lastUsed1MenuItem = new JMenuItem();
        this.lastUsed2MenuItem = new JMenuItem();
        this.lastUsed3MenuItem = new JMenuItem();
        this.lastUsed4MenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.windowMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        this.copyMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        this.pasteMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        this.deleteMenuItem = new JMenuItem(new AbstractAction(this.getResourceConverter().getString("workbench.menu.delete", "Delete")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame jf = Workbench.this.desktopPane.getSelectedFrame();
                if (jf != null && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                    SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
                    TreePath tpath = se.tree.getSelectionPath();
                    se.delete(tpath);
                }
            }
        });
        this.aboutMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.viewMenu = new JMenu();
        this.viewXmlMenuItem = new JCheckBoxMenuItem();
        this.setTitle(this.getResourceConverter().getString("workbench.panel.title", "Schema Workbench"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Workbench.this.storeWorkbenchProperties();
                Workbench.this.storeDatabaseMeta();
                Workbench.this.closeAllSchemaFrames(true);
            }
        });
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.newSchemaMenuItem2.setText(this.getResourceConverter().getString("workbench.menu.newSchema", "Schema"));
        this.newSchemaMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newSchemaMenuItemActionPerformed(evt);
            }
        });
        this.newQueryMenuItem2.setText(this.getResourceConverter().getString("workbench.menu.newQuery", "MDX Query"));
        this.newQueryMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newQueryMenuItemActionPerformed(evt);
            }
        });
        this.newJDBCExplorerMenuItem2.setText(this.getResourceConverter().getString("workbench.menu.newJDBC", "JDBC Explorer"));
        this.newJDBCExplorerMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newJDBCExplorerMenuItemActionPerformed(evt);
            }
        });
        this.toolbarNewPopupMenu.add(this.newSchemaMenuItem2);
        this.toolbarNewPopupMenu.add(this.newQueryMenuItem2);
        this.toolbarNewPopupMenu.add(this.newJDBCExplorerMenuItem2);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setMaximumSize(new Dimension(50, 28));
        this.toolbarNewButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("new"))));
        this.toolbarNewButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.new", "New"));
        this.toolbarNewButton.setBorderPainted(false);
        this.toolbarNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toolbarNewPopupMenu.show(Workbench.this.jPanel2, 0, ((Workbench)Workbench.this).jPanel2.getSize().height);
            }
        });
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.add(this.toolbarNewButton);
        this.jPanel2.add((Component)this.jToolBar2, "Center");
        this.toolbarNewArrowButton = new BasicArrowButton(5);
        this.toolbarNewArrowButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.newArrow", "New"));
        this.toolbarNewArrowButton.setBorderPainted(false);
        this.toolbarNewArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toolbarNewPopupMenu.show(Workbench.this.jPanel2, 0, ((Workbench)Workbench.this).jPanel2.getSize().height);
            }
        });
        this.jPanel2.add((Component)this.toolbarNewArrowButton, "East");
        this.jToolBar1.add((Component)this.jPanel2, 0);
        this.toolbarOpenButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("open"))));
        this.toolbarOpenButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.open", "Open"));
        this.toolbarOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.openMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarOpenButton);
        this.toolbarSaveButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("save"))));
        this.toolbarSaveButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.save", "Save"));
        this.toolbarSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveButton);
        this.toolbarSaveAsButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("saveAs"))));
        this.toolbarSaveAsButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.saveAs", "Save As"));
        this.toolbarSaveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveAsButton);
        this.jPanel1.setMaximumSize(new Dimension(8, 8));
        this.jToolBar1.add(this.jPanel1);
        this.toolbarPreferencesButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("preferences"))));
        this.toolbarPreferencesButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.connection", "Connection"));
        this.toolbarPreferencesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.connectionButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarPreferencesButton);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.fileMenu.setText(this.getResourceConverter().getString("workbench.menu.file", "File"));
        this.fileMenu.setMnemonic(70);
        this.newMenu.setText(this.getResourceConverter().getString("workbench.menu.new", "New"));
        this.newSchemaMenuItem.setText(this.getResourceConverter().getString("workbench.menu.newSchema", "Schema"));
        this.newSchemaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newSchemaMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newSchemaMenuItem);
        this.newQueryMenuItem.setText(this.getResourceConverter().getString("workbench.menu.newQuery", "MDX Query"));
        this.newQueryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newQueryMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newQueryMenuItem);
        this.newJDBCExplorerMenuItem.setText(this.getResourceConverter().getString("workbench.menu.newJDBC", "JDBC Explorer"));
        this.newJDBCExplorerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newJDBCExplorerMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newJDBCExplorerMenuItem);
        this.fileMenu.add(this.newMenu);
        this.openMenuItem.setText(this.getResourceConverter().getString("workbench.menu.open", "Open"));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText(this.getResourceConverter().getString("workbench.menu.save", "Save"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(this.getResourceConverter().getString("workbench.menu.saveAsDot", "Save As ..."));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.lastUsed1MenuItem.setText(this.getWorkbenchProperty(LAST_USED1));
        this.lastUsed1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed1MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed1MenuItem);
        this.lastUsed2MenuItem.setText(this.getWorkbenchProperty(LAST_USED2));
        this.lastUsed2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed2MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed2MenuItem);
        this.lastUsed3MenuItem.setText(this.getWorkbenchProperty(LAST_USED3));
        this.lastUsed3MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed3MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed3MenuItem);
        this.lastUsed4MenuItem.setText(this.getWorkbenchProperty(LAST_USED4));
        this.lastUsed4MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed4MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed4MenuItem);
        this.updateLastUsedMenu();
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText(this.getResourceConverter().getString("workbench.menu.exit", "Exit"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(this.getResourceConverter().getString("workbench.menu.edit", "Edit"));
        this.editMenu.setMnemonic(69);
        this.cutMenuItem.setText(this.getResourceConverter().getString("workbench.menu.cut", "Cut"));
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText(this.getResourceConverter().getString("workbench.menu.copy", "Copy"));
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText(this.getResourceConverter().getString("workbench.menu.paste", "Paste"));
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.viewMenu.setText(this.getResourceConverter().getString("workbench.menu.view", "View"));
        this.viewMenu.setMnemonic(86);
        this.viewXmlMenuItem.setText(this.getResourceConverter().getString("workbench.menu.viewXML", "View XML"));
        this.viewXmlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.viewXMLMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewXmlMenuItem);
        this.menuBar.add(this.viewMenu);
        this.toolsMenu.setText(this.getResourceConverter().getString("workbench.menu.options", "Options"));
        this.toolsMenu.setMnemonic(79);
        this.preferencesMenuItem.setText(this.getResourceConverter().getString("workbench.menu.connection", "Connection"));
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.connectionButtonActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.preferencesMenuItem);
        this.requireSchemaCheckboxMenuItem.setText(this.getResourceConverter().getString("workbench.menu.requireSchema", "Require Schema"));
        this.requireSchemaCheckboxMenuItem.setSelected(this.requireSchema);
        this.requireSchemaCheckboxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.requireSchemaActionPerformed(e);
            }
        });
        this.toolsMenu.add(this.requireSchemaCheckboxMenuItem);
        this.menuBar.add(this.toolsMenu);
        this.windowMenu.setText(this.getResourceConverter().getString("workbench.menu.windows", "Windows"));
        this.windowMenu.setMnemonic(87);
        this.cascadeMenuItem = new JMenuItem();
        this.cascadeMenuItem.setText(this.getResourceConverter().getString("workbench.menu.cascadeWindows", "Cascade Windows"));
        this.cascadeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.cascadeMenuItemActionPerformed(evt);
            }
        });
        this.tileMenuItem = new JMenuItem();
        this.tileMenuItem.setText(this.getResourceConverter().getString("workbench.menu.tileWindows", "Tile Windows"));
        this.tileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.tileMenuItemActionPerformed(evt);
            }
        });
        this.closeAllMenuItem = new JMenuItem();
        this.closeAllMenuItem.setText(this.getResourceConverter().getString("workbench.menu.closeAll", "Close All"));
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.closeAllMenuItemActionPerformed(evt);
            }
        });
        this.minimizeMenuItem = new JMenuItem();
        this.minimizeMenuItem.setText(this.getResourceConverter().getString("workbench.menu.minimizeAll", "Minimize All"));
        this.minimizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.minimizeMenuItemActionPerformed(evt);
            }
        });
        this.maximizeMenuItem = new JMenuItem();
        this.maximizeMenuItem.setText(this.getResourceConverter().getString("workbench.menu.maximizeAll", "Maximize All"));
        this.maximizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.maximizeMenuItemActionPerformed(evt);
            }
        });
        this.menuBar.add(this.windowMenu);
        this.aboutMenuItem.setText(this.getResourceConverter().getString("workbench.menu.about", "About"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Workbench.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenu.setText(this.getResourceConverter().getString("workbench.menu.help", "Help"));
        this.helpMenu.setMnemonic(72);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMenubarPlugins() {
        InputStream pluginStream = null;
        try {
            Properties props = new Properties();
            pluginStream = this.getClass().getResourceAsStream("/workbench_plugins.properties");
            if (pluginStream != null) {
                props.load(pluginStream);
                for (Object key : props.keySet()) {
                    String keystr = (String)key;
                    if (!keystr.startsWith("workbench.menu-plugin")) continue;
                    String val = props.getProperty(keystr);
                    WorkbenchMenubarPlugin plugin = (WorkbenchMenubarPlugin)Class.forName(val).newInstance();
                    plugin.setWorkbench(this);
                    plugin.addItemsToMenubar(this.menuBar);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pluginStream != null) {
                    pluginStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ResourceBundle getWorkbenchResourceBundle() {
        return workbenchResourceBundle;
    }

    public I18n getResourceConverter() {
        if (resourceConverter == null) {
            resourceConverter = Workbench.getGlobalResourceConverter();
        }
        return resourceConverter;
    }

    private void tileMenuItemActionPerformed(ActionEvent evt) {
        Dimension dsize = this.desktopPane.getSize();
        int desktopW = (int)dsize.getWidth();
        int desktopH = (int)dsize.getHeight();
        int darea = desktopW * desktopH;
        double eacharea = darea / (this.schemaWindowMap.size() + this.mdxWindows.size() + this.jdbcWindows.size());
        int wh = (int)Math.sqrt(eacharea);
        try {
            int x = 0;
            int y = 0;
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null || sf.isIcon()) continue;
                sf.setMaximum(false);
                sf.moveToFront();
                if (x >= desktopW || (double)((desktopW - x) * wh) < eacharea / 2.0) {
                    y += wh;
                    x = 0;
                }
                int sfwidth = x + wh < desktopW ? wh : desktopW - x;
                int sfheight = y + wh < desktopH ? wh : desktopH - y;
                sf.setBounds(x, y, sfwidth, sfheight);
                x += sfwidth;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"tileMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void cascadeMenuItemActionPerformed(ActionEvent evt) {
        try {
            int sfi = 1;
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null || sf.isIcon()) continue;
                sf.setMaximum(false);
                sf.setLocation(30 * sfi, 30 * sfi);
                sf.moveToFront();
                sf.setSelected(true);
                ++sfi;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"cascadeMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void closeAllMenuItemActionPerformed(ActionEvent evt) {
        this.closeAllSchemaFrames(false);
    }

    private void closeAllSchemaFrames(boolean exitAfterClose) {
        try {
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null) continue;
                if (sf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                    SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
                    sf.setSelected(true);
                    int response = this.confirmFrameClose(sf, se);
                    switch (response) {
                        case 2: {
                            return;
                        }
                        case 3: {
                            sf.setClosed(true);
                        }
                    }
                    continue;
                }
                sf.setClosed(true);
            }
            if (this.schemaWindowMap.keySet().size() == 0 && exitAfterClose) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"closeAllSchemaFrames", (Throwable)ex);
        }
    }

    private int confirmFrameClose(JInternalFrame schemaFrame, SchemaExplorer se) {
        if (se.isDirty()) {
            JMenuItem schemaMenuItem = this.schemaWindowMap.get(this.desktopPane.getSelectedFrame());
            int answer = JOptionPane.showConfirmDialog(null, this.getResourceConverter().getFormattedString("workbench.saveSchemaOnClose.alert", "Save changes to {0}?", se.getSchemaFile().toString()), this.getResourceConverter().getString("workbench.saveSchemaOnClose.title", "Schema"), 1);
            switch (answer) {
                case 0: {
                    this.saveMenuItemActionPerformed(null);
                    this.schemaWindowMap.remove(schemaFrame);
                    this.updateMDXCatalogList();
                    schemaFrame.dispose();
                    this.windowMenu.remove(schemaMenuItem);
                    break;
                }
                case 1: {
                    schemaFrame.dispose();
                    this.schemaWindowMap.remove(schemaFrame);
                    this.windowMenu.remove(schemaMenuItem);
                    break;
                }
                case 2: {
                    try {
                        schemaFrame.setClosed(false);
                        schemaFrame.show();
                        break;
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)ex);
                    }
                }
            }
            return answer;
        }
        return 3;
    }

    private void minimizeMenuItemActionPerformed(ActionEvent evt) {
        try {
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null || sf.isIcon()) continue;
                sf.setIcon(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"minimizeMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void maximizeMenuItemActionPerformed(ActionEvent evt) {
        try {
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null) continue;
                sf.setIcon(false);
                sf.setMaximum(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"maximizeMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private Iterable<JInternalFrame> getAllFrames() {
        return UnionIterator.over((Collection[])new Collection[]{this.schemaWindowMap.keySet(), this.mdxWindows, this.jdbcWindows});
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        try {
            URL versionUrl = this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("version"));
            InputStream versionIn = versionUrl.openStream();
            String ver = IOUtils.toString((InputStream)versionIn);
            ver = ver.replace("PRODUCT_VERSION", MondrianServerRegistry.INSTANCE.getProductVersion());
            ver = ver.replace("COPYRIGHT_YEAR", MondrianServerRegistry.INSTANCE.getCopyrightYear());
            JEditorPane jEditorPane = new JEditorPane("text/html", ver);
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            JInternalFrame jf = new JInternalFrame();
            jf.setTitle("About");
            jf.getContentPane().add(jPanel);
            Dimension screenSize = this.getSize();
            int aboutW = 400;
            int aboutH = 300;
            int width = screenSize.width / 2 - aboutW / 2;
            int height = screenSize.height / 2 - aboutH / 2 - 100;
            jf.setBounds(width, height, aboutW, aboutH);
            jf.setClosable(true);
            this.desktopPane.add(jf);
            jf.setVisible(true);
            jf.show();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"aboutMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void newJDBCExplorerMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (this.jdbcMetaData == null) {
                this.getNewJdbcMetadata();
            }
            final JInternalFrame jf = new JInternalFrame();
            jf.setTitle(this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.title", "JDBC Explorer - {0} {1}", this.jdbcMetaData.getDatabaseProductName(), this.jdbcMetaData.getJdbcConnectionUrl()));
            this.getNewJdbcMetadata();
            JdbcExplorer jdbce = new JdbcExplorer(this.jdbcMetaData, this);
            jf.getContentPane().add(jdbce);
            jf.setBounds(0, 0, 500, 480);
            jf.setClosable(true);
            jf.setIconifiable(true);
            jf.setMaximizable(true);
            jf.setResizable(true);
            jf.setVisible(true);
            final JMenuItem jdbcMenuItem = new JMenuItem();
            jdbcMenuItem.setText(this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.menuitem", "{0} JDBC Explorer", Integer.toString(this.windowMenuMapIndex++)));
            jdbcMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (jf.isIcon()) {
                            jf.setIcon(false);
                        } else {
                            jf.setSelected(true);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"queryMenuItem", (Throwable)ex);
                    }
                }
            });
            jf.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    Workbench.this.jdbcWindows.remove(jf);
                    jf.dispose();
                    Workbench.this.windowMenu.remove(jdbcMenuItem);
                }
            });
            this.desktopPane.add(jf);
            jf.setVisible(true);
            jf.show();
            try {
                jf.setSelected(true);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"newJDBCExplorerMenuItemActionPerformed.setSelected", (Throwable)ex);
            }
            this.jdbcWindows.add(jf);
            this.windowMenu.add((Component)jdbcMenuItem, -1);
            this.windowMenu.add((Component)this.jSeparator3, -1);
            this.windowMenu.add((Component)this.cascadeMenuItem, -1);
            this.windowMenu.add((Component)this.tileMenuItem, -1);
            this.windowMenu.add((Component)this.minimizeMenuItem, -1);
            this.windowMenu.add((Component)this.maximizeMenuItem, -1);
            this.windowMenu.add((Component)this.closeAllMenuItem, -1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.exception", "Database connection not successful.\n{0}", ex.getLocalizedMessage()), this.getResourceConverter().getString("workbench.new.JDBCExplorer.exception.title", "Database Connection Error"), 0);
            LOGGER.error((Object)"newJDBCExplorerMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private DatabaseMeta getDbMeta(String xml) {
        try {
            if (!KettleClientEnvironment.isInitialized()) {
                System.setProperty("KETTLE_PLUGIN_BASE_FOLDERS", KETTLE_PLUGIN_BASE_FOLDERS);
                KettleClientEnvironment.init();
            }
            if (this.dbMeta != null) {
                return this.dbMeta;
            }
            this.dbMeta = xml == null ? new DatabaseMeta() : new DatabaseMeta(xml);
        }
        catch (KettleException e) {
            throw new RuntimeException(this.getResourceConverter().getFormattedString("workbench.new.Kettle.exception", "Kettle failed to initialize.", new Object[0]), e);
        }
        return this.dbMeta;
    }

    private void connectionButtonActionPerformed(ActionEvent evt) {
        if (this.connectionDialog == null) {
            this.dbMeta = this.getDbMeta(null);
            this.connectionDialogController = new DataHandler();
            this.connectionDialogController.setName("dataHandler");
            XulDomContainer container = null;
            try {
                SwingXulLoader loader = new SwingXulLoader();
                container = loader.loadXul("org/pentaho/ui/database/databasedialog.xul", (Object)Messages.getBundle());
            }
            catch (XulException e) {
                throw new RuntimeException("Xul failed to initialize", e);
            }
            container.addEventHandler((XulEventHandler)this.connectionDialogController);
            this.connectionDialogController.loadConnectionData();
            this.connectionDialogController.setData((Object)this.dbMeta);
            this.connectionDialog = (XulDialog)container.getDocumentRoot().getRootElement();
        }
        this.connectionDialog.show();
        this.dbMeta = (DatabaseMeta)this.connectionDialogController.getData();
        if (this.dbMeta.hasChanged()) {
            this.dbMeta.clearChanged();
            this.syncToWorkspace(this.dbMeta);
            this.resetWorkbench();
        }
    }

    private void syncToWorkspace(DatabaseMeta databaseMeta) {
        try {
            this.jdbcConnectionUrl = databaseMeta.getURL();
        }
        catch (KettleDatabaseException e) {
            throw new RuntimeException("Failed to determine JDBC URL", e);
        }
        this.jdbcDriverClassName = databaseMeta.getDriverClass();
        this.jdbcUsername = databaseMeta.getUsername();
        this.jdbcPassword = databaseMeta.getPassword();
        Map options = this.dbMeta.getExtraOptions();
        String dbType = this.dbMeta.getDatabaseInterface().getPluginId();
        this.jdbcSchema = (String)options.get(dbType + "." + FILTER_SCHEMA_LIST);
        if (this.jdbcDriverClassName != null) {
            this.setWorkbenchProperty("jdbcDriverClassName", this.jdbcDriverClassName);
        }
        if (this.jdbcConnectionUrl != null) {
            this.setWorkbenchProperty("jdbcConnectionUrl", this.jdbcConnectionUrl);
        }
        if (this.jdbcUsername != null) {
            this.setWorkbenchProperty("jdbcUsername", this.jdbcUsername);
        }
        if (this.jdbcPassword != null) {
            this.setWorkbenchProperty("jdbcPassword", this.jdbcPassword);
        }
        if (this.jdbcSchema != null) {
            this.setWorkbenchProperty("jdbcSchema", this.jdbcSchema);
        }
    }

    private void requireSchemaActionPerformed(ActionEvent evt) {
        this.requireSchema = ((JCheckBoxMenuItem)evt.getSource()).isSelected();
        this.setWorkbenchProperty("requireSchema", "" + this.requireSchema);
    }

    private void newSchemaMenuItemActionPerformed(ActionEvent evt) {
        File outputFile;
        MondrianProperties.instance();
        File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
        while ((outputFile = new File(defaultDir, "Schema" + newSchema++ + ".xml")).exists()) {
        }
        this.openSchemaFrame(outputFile, true);
    }

    private void newQueryMenuItemActionPerformed(ActionEvent evt) {
        JMenuItem schemaMenuItem = this.schemaWindowMap.get(this.desktopPane.getSelectedFrame());
        final JInternalFrame jf = new JInternalFrame();
        jf.setTitle(this.getResourceConverter().getString("workbench.new.MDXQuery.title", "MDX Query"));
        QueryPanel qp = new QueryPanel(this);
        jf.getContentPane().add(qp);
        jf.setBounds(0, 0, 500, 480);
        jf.setClosable(true);
        jf.setIconifiable(true);
        jf.setMaximizable(true);
        jf.setResizable(true);
        jf.setVisible(true);
        this.desktopPane.add(jf);
        jf.show();
        try {
            jf.setSelected(true);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"newQueryMenuItemActionPerformed.setSelected", (Throwable)ex);
        }
        this.mdxWindows.add(jf);
        final JMenuItem queryMenuItem = new JMenuItem();
        queryMenuItem.setText(this.getResourceConverter().getFormattedString("workbench.new.MDXQuery.menuitem", "{0} MDX", Integer.toString(this.windowMenuMapIndex)));
        queryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (jf.isIcon()) {
                        jf.setIcon(false);
                    } else {
                        jf.setSelected(true);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"queryMenuItem", (Throwable)ex);
                }
            }
        });
        jf.setDefaultCloseOperation(0);
        jf.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                Workbench.this.mdxWindows.remove(jf);
                jf.dispose();
                Workbench.this.windowMenu.remove(queryMenuItem);
            }
        });
        this.windowMenu.add((Component)queryMenuItem, -1);
        this.windowMenu.add((Component)this.jSeparator3, -1);
        this.windowMenu.add((Component)this.cascadeMenuItem, -1);
        this.windowMenu.add((Component)this.tileMenuItem, -1);
        this.windowMenu.add((Component)this.minimizeMenuItem, -1);
        this.windowMenu.add((Component)this.maximizeMenuItem, -1);
        this.windowMenu.add((Component)this.closeAllMenuItem, -1);
        qp.setMenuItem(queryMenuItem);
        qp.setSchemaWindowMap(this.schemaWindowMap);
        qp.setWindowMenuIndex(this.windowMenuMapIndex++);
        if (schemaMenuItem != null) {
            qp.initConnection(schemaMenuItem.getText());
        } else {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("workbench.new.MDXQuery.no.selection", "No Mondrian connection. Select a Schema to connect."), this.getResourceConverter().getString("workbench.new.MDXQuery.no.selection.title", "Alert"), 2);
        }
    }

    private void updateMDXCatalogList() {
        for (JInternalFrame elem : this.mdxWindows) {
            QueryPanel qp = (QueryPanel)elem.getContentPane().getComponent(0);
            qp.setSchemaWindowMap(this.schemaWindowMap);
        }
    }

    public SchemaExplorer getCurrentSchemaExplorer() {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf != null && jf.getContentPane().getComponentCount() > 0 && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            return (SchemaExplorer)jf.getContentPane().getComponent(0);
        }
        return null;
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf != null && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            File schemaFile;
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            File oldSchemaFile = schemaFile = se.getSchemaFile();
            File suggSchemaFile = new File(schemaFile == null ? se.getSchema().name.trim() + ".xml" : schemaFile.getName());
            MondrianGuiDef.Schema schema = se.getSchema();
            JFileChooser jfc = new JFileChooser();
            MondrianProperties.instance();
            jfc.setSelectedFile(suggSchemaFile);
            if (!this.isSchemaValid(schema)) {
                return;
            }
            if (jfc.showSaveDialog(this) == 0) {
                try {
                    int answer;
                    schemaFile = jfc.getSelectedFile();
                    if (!oldSchemaFile.equals(schemaFile) && schemaFile.exists() && (answer = JOptionPane.showConfirmDialog(null, this.getResourceConverter().getFormattedString("workbench.saveAs.schema.confirm", "{0} schema file already exists. Do you want to replace it?", schemaFile.getAbsolutePath()), this.getResourceConverter().getString("workbench.saveAs.schema.confirm.title", "Save As"), 0)) == 1) {
                        return;
                    }
                    if (se.isNewFile() && !oldSchemaFile.equals(schemaFile)) {
                        oldSchemaFile.delete();
                    }
                    if (se.isNewFile()) {
                        se.setNewFile(false);
                    }
                    se.setDirty(false);
                    se.setDirtyFlag(false);
                    XMLOutput out = new XMLOutput((Writer)new FileWriter(jfc.getSelectedFile()));
                    out.setAlwaysQuoteCData(true);
                    out.setIndentString("  ");
                    schema.displayXML(out);
                    se.setSchemaFile(schemaFile);
                    se.setTitle();
                    this.setLastUsed(jfc.getSelectedFile().getName(), jfc.getSelectedFile().toURI().toURL().toString());
                    JMenuItem sMenuItem = this.schemaWindowMap.get(jf);
                    String[] mtexttokens = sMenuItem.getText().split(" ");
                    sMenuItem.setText(mtexttokens[0] + " " + se.getSchemaFile().getName());
                    this.updateMDXCatalogList();
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex);
                }
            }
        }
    }

    private boolean isSchemaValid(MondrianGuiDef.Schema schema) {
        try {
            StringWriter writer = new StringWriter();
            XMLOutput xmlOutput = new XMLOutput((Writer)writer);
            schema.displayXML(xmlOutput);
            Parser xmlParser = XOMUtil.createDefaultParser();
            StringReader reader = new StringReader(writer.getBuffer().toString());
            new MondrianGuiDef.Schema(xmlParser.parse((Reader)reader));
        }
        catch (XOMException e) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.save.invalid.schema", "Please correct the following error before saving:", e.getLocalizedMessage()), this.getResourceConverter().getFormattedString("workbench.save.invalid.schema.title", "Cannot Save", new Object[0]), 2);
            return false;
        }
        return true;
    }

    private void viewXMLMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        boolean oldValue = this.viewXmlMenuItem.getState();
        if (jf != null && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            ((JCheckBoxMenuItem)evt.getSource()).setSelected(se.editMode(evt));
            return;
        }
        this.viewXmlMenuItem.setSelected(!oldValue);
    }

    public void saveMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf == null || jf.getContentPane() == null) {
            return;
        }
        if (jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            File schemaFile = se.getSchemaFile();
            if (se.isNewFile()) {
                this.saveAsMenuItemActionPerformed(evt);
                return;
            }
            se.setDirty(false);
            se.setDirtyFlag(false);
            se.setTitle();
            MondrianGuiDef.Schema schema = se.getSchema();
            if (!this.isSchemaValid(schema)) {
                return;
            }
            MondrianProperties.instance();
            try {
                XMLOutput out = new XMLOutput((Writer)new FileWriter(schemaFile));
                out.setAlwaysQuoteCData(true);
                out.setIndentString("  ");
                schema.displayXML(out);
                this.setLastUsed(schemaFile.getName(), schemaFile.toURI().toURL().toString());
            }
            catch (Exception ex) {
                LOGGER.error((Object)"saveMenuItemActionPerformed", (Throwable)ex);
            }
        }
    }

    private void setLastUsed(String name, String url) {
        int i;
        int match = 4;
        String luName = null;
        String propname = null;
        String lastUsed = "lastUsed";
        String lastUsedUrl = "lastUsedUrl";
        for (i = 1; i <= 4; ++i) {
            propname = lastUsed + i;
            luName = this.getWorkbenchProperty(propname);
            if (luName == null || !luName.equals(name)) continue;
            match = i;
            break;
        }
        for (i = match; i > 1; --i) {
            if (this.getWorkbenchProperty(lastUsed + (i - 1)) == null) continue;
            this.setWorkbenchProperty(lastUsed + i, this.getWorkbenchProperty(lastUsed + (i - 1)));
            this.setWorkbenchProperty(lastUsedUrl + i, this.getWorkbenchProperty(lastUsedUrl + (i - 1)));
        }
        this.setWorkbenchProperty(LAST_USED1, name);
        this.setWorkbenchProperty(LAST_USED1_URL, url);
        this.updateLastUsedMenu();
        this.storeWorkbenchProperties();
        this.storeDatabaseMeta();
    }

    private void updateLastUsedMenu() {
        if (this.getWorkbenchProperty(LAST_USED1) == null) {
            this.jSeparator2.setVisible(false);
        } else {
            this.jSeparator2.setVisible(true);
        }
        if (this.getWorkbenchProperty(LAST_USED1) != null) {
            this.lastUsed1MenuItem.setVisible(true);
        } else {
            this.lastUsed1MenuItem.setVisible(false);
        }
        if (this.getWorkbenchProperty(LAST_USED2) != null) {
            this.lastUsed2MenuItem.setVisible(true);
        } else {
            this.lastUsed2MenuItem.setVisible(false);
        }
        if (this.getWorkbenchProperty(LAST_USED3) != null) {
            this.lastUsed3MenuItem.setVisible(true);
        } else {
            this.lastUsed3MenuItem.setVisible(false);
        }
        if (this.getWorkbenchProperty(LAST_USED4) != null) {
            this.lastUsed4MenuItem.setVisible(true);
        } else {
            this.lastUsed4MenuItem.setVisible(false);
        }
        this.lastUsed1MenuItem.setText(this.getWorkbenchProperty(LAST_USED1));
        this.lastUsed2MenuItem.setText(this.getWorkbenchProperty(LAST_USED2));
        this.lastUsed3MenuItem.setText(this.getWorkbenchProperty(LAST_USED3));
        this.lastUsed4MenuItem.setText(this.getWorkbenchProperty(LAST_USED4));
    }

    private void lastUsed1MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.getWorkbenchProperty(LAST_USED1_URL))), false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"lastUsed1MenuItemActionPerformed", (Throwable)e);
        }
    }

    private void lastUsed2MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.getWorkbenchProperty(LAST_USED2_URL))), false);
            this.setLastUsed(this.getWorkbenchProperty(LAST_USED2), this.getWorkbenchProperty(LAST_USED2_URL));
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"lastUsed2MenuItemActionPerformed", (Throwable)e);
        }
    }

    private void lastUsed3MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.getWorkbenchProperty(LAST_USED3_URL))), false);
            this.setLastUsed(this.getWorkbenchProperty(LAST_USED3), this.getWorkbenchProperty(LAST_USED3_URL));
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"lastUsed3MenuItemActionPerformed", (Throwable)e);
        }
    }

    private void lastUsed4MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.getWorkbenchProperty(LAST_USED4_URL))), false);
            this.setLastUsed(this.getWorkbenchProperty(LAST_USED4), this.getWorkbenchProperty(LAST_USED4_URL));
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"lastUsed4MenuItemActionPerformed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSchemaFrame(File file, boolean newFile) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!newFile) {
                if (this.checkFileOpen(file)) {
                    return;
                }
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.not.found", "{0} File not found.", file.getAbsolutePath()), this.getResourceConverter().getString("workbench.open.schema.not.found.title", "Alert"), 2);
                    return;
                }
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.not.writeable", "{0} is not writeable.", file.getAbsolutePath()), this.getResourceConverter().getString("workbench.open.schema.not.writeable.title", "Alert"), 2);
                    return;
                }
                this.checkSchemaFile(file);
            }
            final JInternalFrame schemaFrame = new JInternalFrame();
            schemaFrame.setTitle(this.getResourceConverter().getFormattedString("workbench.open.schema.title", "Schema - {0}", file.getName()));
            this.getNewJdbcMetadata();
            schemaFrame.getContentPane().add(new SchemaExplorer(this, file, this.jdbcMetaData, newFile, schemaFrame));
            String errorOpening = ((SchemaExplorer)schemaFrame.getContentPane().getComponent(0)).getErrMsg();
            if (errorOpening != null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.error", "Error opening schema - {0}.", errorOpening), this.getResourceConverter().getString("workbench.open.schema.error.title", "Error"), 0);
                schemaFrame.setClosed(true);
                return;
            }
            schemaFrame.setBounds(0, 0, 1000, 650);
            schemaFrame.setClosable(true);
            schemaFrame.setIconifiable(true);
            schemaFrame.setMaximizable(true);
            schemaFrame.setResizable(true);
            schemaFrame.setVisible(true);
            this.desktopPane.add((Component)schemaFrame, JLayeredPane.DEFAULT_LAYER);
            schemaFrame.show();
            schemaFrame.setMaximum(true);
            this.displayWarningOnFailedConnection();
            final JMenuItem schemaMenuItem = new JMenuItem();
            schemaMenuItem.setText(this.windowMenuMapIndex++ + " " + file.getName());
            schemaMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (schemaFrame.isIcon()) {
                            schemaFrame.setIcon(false);
                        } else {
                            schemaFrame.setSelected(true);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"schemaMenuItem", (Throwable)ex);
                    }
                }
            });
            this.windowMenu.add((Component)schemaMenuItem, 0);
            this.windowMenu.setEnabled(true);
            this.windowMenu.add((Component)this.jSeparator3, -1);
            this.windowMenu.add((Component)this.cascadeMenuItem, -1);
            this.windowMenu.add((Component)this.tileMenuItem, -1);
            this.windowMenu.add((Component)this.minimizeMenuItem, -1);
            this.windowMenu.add((Component)this.maximizeMenuItem, -1);
            this.windowMenu.add((Component)this.closeAllMenuItem, -1);
            this.schemaWindowMap.put(schemaFrame, schemaMenuItem);
            this.updateMDXCatalogList();
            schemaFrame.setDefaultCloseOperation(0);
            schemaFrame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    SchemaExplorer se;
                    int response;
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer && (response = Workbench.this.confirmFrameClose(schemaFrame, se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0))) == 3) {
                        if (se.isNewFile()) {
                            se.getSchemaFile().delete();
                        }
                        Workbench.this.schemaWindowMap.remove(schemaFrame);
                        Workbench.this.updateMDXCatalogList();
                        schemaFrame.dispose();
                        Workbench.this.windowMenu.remove(schemaMenuItem);
                    }
                }
            });
            schemaFrame.setFocusable(true);
            schemaFrame.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                        SchemaExplorer se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0);
                        Workbench.this.viewXmlMenuItem.setSelected(se.isEditModeXML());
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                        SchemaExplorer se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0);
                        Workbench.this.viewXmlMenuItem.setSelected(se.isEditModeXML());
                    }
                }
            });
            this.viewXmlMenuItem.setSelected(false);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"openSchemaFrame", (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        try {
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".xml") || pathname.isDirectory();
                }

                @Override
                public String getDescription() {
                    return Workbench.this.getResourceConverter().getString("workbench.open.schema.file.type", "Mondrian Schema files (*.xml)");
                }
            });
            String lastUsed = this.getWorkbenchProperty(LAST_USED1_URL);
            if (lastUsed != null) {
                jfc.setCurrentDirectory(new File(new URI(lastUsed)));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Could not set file chooser", (Throwable)ex);
        }
        MondrianProperties.instance();
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.setLastUsed(jfc.getSelectedFile().getName(), jfc.getSelectedFile().toURI().toURL().toString());
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)e);
            }
            this.openSchemaFrame(jfc.getSelectedFile(), false);
        }
    }

    private boolean checkFileOpen(File file) {
        for (JInternalFrame elem : this.schemaWindowMap.keySet()) {
            File f = ((SchemaExplorer)elem.getContentPane().getComponent(0)).getSchemaFile();
            if (!f.equals(file)) continue;
            try {
                elem.setSelected(true);
                return true;
            }
            catch (Exception ex) {
                this.schemaWindowMap.remove(elem);
                break;
            }
        }
        return false;
    }

    private void getNewJdbcMetadata() {
        this.jdbcMetaData = new JdbcMetaData(this, this.jdbcDriverClassName, this.jdbcConnectionUrl, this.jdbcUsername, this.jdbcPassword, this.jdbcSchema, this.requireSchema);
    }

    private void resetWorkbench() {
        this.getNewJdbcMetadata();
        for (JInternalFrame theSchemaFrame : this.schemaWindowMap.keySet()) {
            SchemaExplorer theSchemaExplorer = (SchemaExplorer)theSchemaFrame.getContentPane().getComponent(0);
            File theFile = theSchemaExplorer.getSchemaFile();
            if (theFile.exists()) {
                this.checkSchemaFile(theFile);
            }
            theSchemaExplorer.resetMetaData(this.jdbcMetaData);
            theSchemaExplorer.getTreeUpdater().update();
            theSchemaFrame.updateUI();
        }
        this.displayWarningOnFailedConnection();
        for (JInternalFrame jdbcFrame : this.jdbcWindows) {
            JdbcExplorer explorer = (JdbcExplorer)jdbcFrame.getContentPane().getComponent(0);
            explorer.resetMetaData(this.jdbcMetaData);
            jdbcFrame.setTitle(this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.title", "JDBC Explorer - {0} {1}", this.jdbcMetaData.getDatabaseProductName(), this.jdbcMetaData.getJdbcConnectionUrl()));
            explorer.getTreeUpdater().update();
            explorer.updateUI();
        }
    }

    private void displayWarningOnFailedConnection() {
        if (this.jdbcMetaData != null && this.jdbcMetaData.getErrMsg() != null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.jdbc.error", "Database connection could not be done.\n{0}\nAll validations related to database will be ignored.", this.jdbcMetaData.getErrMsg()), this.getResourceConverter().getString("workbench.open.schema.jdbc.error.title", "Alert"), 2);
        }
    }

    private void checkSchemaFile(File file) {
        try {
            Util.PropertyList list = new Util.PropertyList();
            list.put("Provider", "mondrian");
            list.put("Jdbc", this.jdbcConnectionUrl);
            list.put("Catalog", file.toURI().toURL().toString());
            list.put("JdbcDrivers", this.jdbcDriverClassName);
            if (this.jdbcUsername != null && this.jdbcUsername.length() > 0) {
                list.put("JdbcUser", this.jdbcUsername);
            }
            if (this.jdbcPassword != null && this.jdbcPassword.length() > 0) {
                list.put("JdbcPassword", this.jdbcPassword);
            }
            DriverManager.getConnection((Util.PropertyList)list, null);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception : Schema file " + file.getAbsolutePath() + " is invalid." + ex.getMessage()), (Throwable)ex);
        }
        catch (Error err) {
            LOGGER.error((Object)("Error : Schema file " + file.getAbsolutePath() + " is invalid." + err.getMessage()), (Throwable)err);
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.storeWorkbenchProperties();
        this.storeDatabaseMeta();
        this.closeAllSchemaFrames(true);
    }

    private void parseArgs(String[] args) {
        for (int argNum = 0; argNum < args.length; ++argNum) {
            if (!args[argNum].startsWith("-f=")) continue;
            this.openFile = args[argNum].substring(3);
        }
    }

    public String getTooltip(String titleName) {
        try {
            return this.getWorkbenchResourceBundle().getString(titleName);
        }
        catch (MissingResourceException e) {
            return this.getResourceConverter().getFormattedString("workbench.tooltip.error", "No help available for {0}", titleName);
        }
    }

    public static void main(String[] args) {
        Workbench w = null;
        try {
            File f;
            w = new Workbench();
            w.parseArgs(args);
            w.setSize(800, 600);
            if (w.openFile != null && (f = new File(w.openFile)).canRead()) {
                w.openSchemaFrame(f.getAbsoluteFile(), false);
            }
            w.setVisible(true);
        }
        catch (Throwable ex) {
            if (w != null) {
                JOptionPane.showMessageDialog(w, w.getResourceConverter().getFormattedString("workbench.main.uncoverable_error", "Pentaho Schema Workbench has encountered an unrecoverable error. \n{0}", ex.getLocalizedMessage()), w.getResourceConverter().getString("workbench.main.uncoverable_error.title", "PSW Fatal Error"), 0);
            }
            LOGGER.error((Object)"main", ex);
        }
    }

    public JCheckBoxMenuItem getViewXmlMenuItem() {
        return this.viewXmlMenuItem;
    }

    static {
        LOGGER = Logger.getLogger(Workbench.class);
        workbenchResourceBundle = null;
        resourceConverter = null;
        newSchema = 1;
        KETTLE_PLUGIN_BASE_FOLDERS = "kettle-plugins,plugins," + Const.getKettleDirectory() + Const.FILE_SEPARATOR + "plugins";
    }
}

